/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"asset", "amount", "networkConnectionId", "srcId", "srcType", "fee", "feeLevel", "note"})
public class SmartTransferFundTerm {
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_NETWORK_CONNECTION_ID = "networkConnectionId";
    private String networkConnectionId;
    public static final String JSON_PROPERTY_SRC_ID = "srcId";
    private String srcId;
    public static final String JSON_PROPERTY_SRC_TYPE = "srcType";
    private String srcType;
    public static final String JSON_PROPERTY_FEE = "fee";
    private String fee;
    public static final String JSON_PROPERTY_FEE_LEVEL = "feeLevel";
    private String feeLevel;
    public static final String JSON_PROPERTY_NOTE = "note";
    private String note;

    public SmartTransferFundTerm asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nonnull
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public SmartTransferFundTerm amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public SmartTransferFundTerm networkConnectionId(String networkConnectionId) {
        this.networkConnectionId = networkConnectionId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="networkConnectionId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNetworkConnectionId() {
        return this.networkConnectionId;
    }

    @JsonProperty(value="networkConnectionId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetworkConnectionId(String networkConnectionId) {
        this.networkConnectionId = networkConnectionId;
    }

    public SmartTransferFundTerm srcId(String srcId) {
        this.srcId = srcId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="srcId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSrcId() {
        return this.srcId;
    }

    @JsonProperty(value="srcId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public SmartTransferFundTerm srcType(String srcType) {
        this.srcType = srcType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="srcType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSrcType() {
        return this.srcType;
    }

    @JsonProperty(value="srcType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSrcType(String srcType) {
        this.srcType = srcType;
    }

    public SmartTransferFundTerm fee(String fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(String fee) {
        this.fee = fee;
    }

    public SmartTransferFundTerm feeLevel(String feeLevel) {
        this.feeLevel = feeLevel;
        return this;
    }

    @Nullable
    @JsonProperty(value="feeLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFeeLevel() {
        return this.feeLevel;
    }

    @JsonProperty(value="feeLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeeLevel(String feeLevel) {
        this.feeLevel = feeLevel;
    }

    public SmartTransferFundTerm note(String note) {
        this.note = note;
        return this;
    }

    @Nullable
    @JsonProperty(value="note")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNote() {
        return this.note;
    }

    @JsonProperty(value="note")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNote(String note) {
        this.note = note;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmartTransferFundTerm smartTransferFundTerm = (SmartTransferFundTerm)o;
        return Objects.equals(this.asset, smartTransferFundTerm.asset) && Objects.equals(this.amount, smartTransferFundTerm.amount) && Objects.equals(this.networkConnectionId, smartTransferFundTerm.networkConnectionId) && Objects.equals(this.srcId, smartTransferFundTerm.srcId) && Objects.equals(this.srcType, smartTransferFundTerm.srcType) && Objects.equals(this.fee, smartTransferFundTerm.fee) && Objects.equals(this.feeLevel, smartTransferFundTerm.feeLevel) && Objects.equals(this.note, smartTransferFundTerm.note);
    }

    public int hashCode() {
        return Objects.hash(this.asset, this.amount, this.networkConnectionId, this.srcId, this.srcType, this.fee, this.feeLevel, this.note);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmartTransferFundTerm {\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    networkConnectionId: ").append(this.toIndentedString(this.networkConnectionId)).append("\n");
        sb.append("    srcId: ").append(this.toIndentedString(this.srcId)).append("\n");
        sb.append("    srcType: ").append(this.toIndentedString(this.srcType)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    feeLevel: ").append(this.toIndentedString(this.feeLevel)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAsset() != null) {
            joiner.add(String.format("%sasset%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAsset()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getNetworkConnectionId() != null) {
            joiner.add(String.format("%snetworkConnectionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNetworkConnectionId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSrcId() != null) {
            joiner.add(String.format("%ssrcId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSrcId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSrcType() != null) {
            joiner.add(String.format("%ssrcType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSrcType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFee() != null) {
            joiner.add(String.format("%sfee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFee()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFeeLevel() != null) {
            joiner.add(String.format("%sfeeLevel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFeeLevel()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getNote() != null) {
            joiner.add(String.format("%snote%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNote()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

