/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fireblocks.sdk.model.MediaEntityResponse;
import com.fireblocks.sdk.model.SpamTokenResponse;
import com.fireblocks.sdk.model.TokenCollectionResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "tokenId", "standard", "metadataURI", "cachedMetadataURI", "media", "spam", "collection", "blockchainDescriptor", "description", "name"})
public class TokenResponse {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TOKEN_ID = "tokenId";
    private String tokenId;
    public static final String JSON_PROPERTY_STANDARD = "standard";
    private String standard;
    public static final String JSON_PROPERTY_METADATA_U_R_I = "metadataURI";
    private String metadataURI;
    public static final String JSON_PROPERTY_CACHED_METADATA_U_R_I = "cachedMetadataURI";
    private String cachedMetadataURI;
    public static final String JSON_PROPERTY_MEDIA = "media";
    private List<MediaEntityResponse> media;
    public static final String JSON_PROPERTY_SPAM = "spam";
    private SpamTokenResponse spam;
    public static final String JSON_PROPERTY_COLLECTION = "collection";
    private TokenCollectionResponse collection;
    public static final String JSON_PROPERTY_BLOCKCHAIN_DESCRIPTOR = "blockchainDescriptor";
    private BlockchainDescriptorEnum blockchainDescriptor;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public TokenResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public TokenResponse tokenId(String tokenId) {
        this.tokenId = tokenId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tokenId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTokenId() {
        return this.tokenId;
    }

    @JsonProperty(value="tokenId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public TokenResponse standard(String standard) {
        this.standard = standard;
        return this;
    }

    @Nonnull
    @JsonProperty(value="standard")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStandard() {
        return this.standard;
    }

    @JsonProperty(value="standard")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStandard(String standard) {
        this.standard = standard;
    }

    public TokenResponse metadataURI(String metadataURI) {
        this.metadataURI = metadataURI;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadataURI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetadataURI() {
        return this.metadataURI;
    }

    @JsonProperty(value="metadataURI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadataURI(String metadataURI) {
        this.metadataURI = metadataURI;
    }

    public TokenResponse cachedMetadataURI(String cachedMetadataURI) {
        this.cachedMetadataURI = cachedMetadataURI;
        return this;
    }

    @Nullable
    @JsonProperty(value="cachedMetadataURI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCachedMetadataURI() {
        return this.cachedMetadataURI;
    }

    @JsonProperty(value="cachedMetadataURI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCachedMetadataURI(String cachedMetadataURI) {
        this.cachedMetadataURI = cachedMetadataURI;
    }

    public TokenResponse media(List<MediaEntityResponse> media) {
        this.media = media;
        return this;
    }

    public TokenResponse addMediaItem(MediaEntityResponse mediaItem) {
        if (this.media == null) {
            this.media = new ArrayList<MediaEntityResponse>();
        }
        this.media.add(mediaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="media")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MediaEntityResponse> getMedia() {
        return this.media;
    }

    @JsonProperty(value="media")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMedia(List<MediaEntityResponse> media) {
        this.media = media;
    }

    public TokenResponse spam(SpamTokenResponse spam) {
        this.spam = spam;
        return this;
    }

    @Nullable
    @JsonProperty(value="spam")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SpamTokenResponse getSpam() {
        return this.spam;
    }

    @JsonProperty(value="spam")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpam(SpamTokenResponse spam) {
        this.spam = spam;
    }

    public TokenResponse collection(TokenCollectionResponse collection) {
        this.collection = collection;
        return this;
    }

    @Nullable
    @JsonProperty(value="collection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenCollectionResponse getCollection() {
        return this.collection;
    }

    @JsonProperty(value="collection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCollection(TokenCollectionResponse collection) {
        this.collection = collection;
    }

    public TokenResponse blockchainDescriptor(BlockchainDescriptorEnum blockchainDescriptor) {
        this.blockchainDescriptor = blockchainDescriptor;
        return this;
    }

    @Nonnull
    @JsonProperty(value="blockchainDescriptor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BlockchainDescriptorEnum getBlockchainDescriptor() {
        return this.blockchainDescriptor;
    }

    @JsonProperty(value="blockchainDescriptor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBlockchainDescriptor(BlockchainDescriptorEnum blockchainDescriptor) {
        this.blockchainDescriptor = blockchainDescriptor;
    }

    public TokenResponse description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public TokenResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenResponse tokenResponse = (TokenResponse)o;
        return Objects.equals(this.id, tokenResponse.id) && Objects.equals(this.tokenId, tokenResponse.tokenId) && Objects.equals(this.standard, tokenResponse.standard) && Objects.equals(this.metadataURI, tokenResponse.metadataURI) && Objects.equals(this.cachedMetadataURI, tokenResponse.cachedMetadataURI) && Objects.equals(this.media, tokenResponse.media) && Objects.equals(this.spam, tokenResponse.spam) && Objects.equals(this.collection, tokenResponse.collection) && Objects.equals((Object)this.blockchainDescriptor, (Object)tokenResponse.blockchainDescriptor) && Objects.equals(this.description, tokenResponse.description) && Objects.equals(this.name, tokenResponse.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.tokenId, this.standard, this.metadataURI, this.cachedMetadataURI, this.media, this.spam, this.collection, this.blockchainDescriptor, this.description, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    tokenId: ").append(this.toIndentedString(this.tokenId)).append("\n");
        sb.append("    standard: ").append(this.toIndentedString(this.standard)).append("\n");
        sb.append("    metadataURI: ").append(this.toIndentedString(this.metadataURI)).append("\n");
        sb.append("    cachedMetadataURI: ").append(this.toIndentedString(this.cachedMetadataURI)).append("\n");
        sb.append("    media: ").append(this.toIndentedString(this.media)).append("\n");
        sb.append("    spam: ").append(this.toIndentedString(this.spam)).append("\n");
        sb.append("    collection: ").append(this.toIndentedString(this.collection)).append("\n");
        sb.append("    blockchainDescriptor: ").append(this.toIndentedString((Object)this.blockchainDescriptor)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTokenId() != null) {
            joiner.add(String.format("%stokenId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTokenId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStandard() != null) {
            joiner.add(String.format("%sstandard%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStandard()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMetadataURI() != null) {
            joiner.add(String.format("%smetadataURI%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMetadataURI()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCachedMetadataURI() != null) {
            joiner.add(String.format("%scachedMetadataURI%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCachedMetadataURI()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMedia() != null) {
            for (int i = 0; i < this.getMedia().size(); ++i) {
                if (this.getMedia().get(i) == null) continue;
                joiner.add(this.getMedia().get(i).toUrlQueryString(String.format("%smedia%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getSpam() != null) {
            joiner.add(this.getSpam().toUrlQueryString((String)prefix + JSON_PROPERTY_SPAM + suffix));
        }
        if (this.getCollection() != null) {
            joiner.add(this.getCollection().toUrlQueryString((String)prefix + JSON_PROPERTY_COLLECTION + suffix));
        }
        if (this.getBlockchainDescriptor() != null) {
            joiner.add(String.format("%sblockchainDescriptor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getBlockchainDescriptor()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDescription() != null) {
            joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum BlockchainDescriptorEnum {
        ETH("ETH"),
        ETH_TEST3("ETH_TEST3"),
        ETH_TEST5("ETH_TEST5"),
        ETH_TEST6("ETH_TEST6"),
        POLYGON("POLYGON"),
        POLYGON_TEST_MUMBAI("POLYGON_TEST_MUMBAI"),
        AMOY_POLYGON_TEST("AMOY_POLYGON_TEST"),
        XTZ("XTZ"),
        XTZ_TEST("XTZ_TEST"),
        BASECHAIN_ETH("BASECHAIN_ETH"),
        BASECHAIN_ETH_TEST3("BASECHAIN_ETH_TEST3"),
        ETHERLINK("ETHERLINK"),
        ETHERLINK_TEST("ETHERLINK_TEST"),
        MANTLE("MANTLE"),
        MANTLE_TEST("MANTLE_TEST"),
        GUN_GUNZILLA_TEST("GUN_GUNZILLA_TEST");

        private String value;

        private BlockchainDescriptorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BlockchainDescriptorEnum fromValue(String value) {
            for (BlockchainDescriptorEnum b : BlockchainDescriptorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

