/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.TokenLinkDto;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"data", "next"})
public class TokensPaginatedResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<TokenLinkDto> data = new ArrayList<TokenLinkDto>();
    public static final String JSON_PROPERTY_NEXT = "next";
    private String next;

    public TokensPaginatedResponse data(List<TokenLinkDto> data) {
        this.data = data;
        return this;
    }

    public TokensPaginatedResponse addDataItem(TokenLinkDto dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<TokenLinkDto>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TokenLinkDto> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(List<TokenLinkDto> data) {
        this.data = data;
    }

    public TokensPaginatedResponse next(String next) {
        this.next = next;
        return this;
    }

    @Nullable
    @JsonProperty(value="next")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNext() {
        return this.next;
    }

    @JsonProperty(value="next")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNext(String next) {
        this.next = next;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokensPaginatedResponse tokensPaginatedResponse = (TokensPaginatedResponse)o;
        return Objects.equals(this.data, tokensPaginatedResponse.data) && Objects.equals(this.next, tokensPaginatedResponse.next);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.next);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokensPaginatedResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    next: ").append(this.toIndentedString(this.next)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getData() != null) {
            for (int i = 0; i < this.getData().size(); ++i) {
                if (this.getData().get(i) == null) continue;
                joiner.add(this.getData().get(i).toUrlQueryString(String.format("%sdata%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getNext() != null) {
            joiner.add(String.format("%snext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNext()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

