/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TradingAccountType {
    COIN_FUTURES("COIN_FUTURES"),
    COIN_MARGINED_SWAP("COIN_MARGINED_SWAP"),
    EXCHANGE("EXCHANGE"),
    FUNDING("FUNDING"),
    FUNDABLE("FUNDABLE"),
    FUTURES("FUTURES"),
    FUTURES_CROSS("FUTURES_CROSS"),
    MARGIN("MARGIN"),
    MARGIN_CROSS("MARGIN_CROSS"),
    OPTIONS("OPTIONS"),
    SPOT("SPOT"),
    USDT_MARGINED_SWAP_CROSS("USDT_MARGINED_SWAP_CROSS"),
    USDT_FUTURES("USDT_FUTURES"),
    UNIFIED("UNIFIED");

    private String value;

    private TradingAccountType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static TradingAccountType fromValue(String value) {
        for (TradingAccountType b : TradingAccountType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

