/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "state", "timestamp", "instructionId"})
public class Transaction {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private BigDecimal timestamp;
    public static final String JSON_PROPERTY_INSTRUCTION_ID = "instructionId";
    private String instructionId;

    public Transaction id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public Transaction state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public Transaction timestamp(BigDecimal timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(BigDecimal timestamp) {
        this.timestamp = timestamp;
    }

    public Transaction instructionId(String instructionId) {
        this.instructionId = instructionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="instructionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInstructionId() {
        return this.instructionId;
    }

    @JsonProperty(value="instructionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstructionId(String instructionId) {
        this.instructionId = instructionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.id, transaction.id) && Objects.equals((Object)this.state, (Object)transaction.state) && Objects.equals(this.timestamp, transaction.timestamp) && Objects.equals(this.instructionId, transaction.instructionId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.timestamp, this.instructionId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    instructionId: ").append(this.toIndentedString(this.instructionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getState() != null) {
            joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getState()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTimestamp() != null) {
            joiner.add(String.format("%stimestamp%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTimestamp()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInstructionId() != null) {
            joiner.add(String.format("%sinstructionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getInstructionId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum StateEnum {
        SUBMITTED("SUBMITTED"),
        QUEUED("QUEUED"),
        PENDING_AUTHORIZATION("PENDING_AUTHORIZATION"),
        PENDING_SIGNATURE("PENDING_SIGNATURE"),
        BROADCASTING("BROADCASTING"),
        PENDING_3RD_PARTY_MANUAL_APPROVAL("PENDING_3RD_PARTY_MANUAL_APPROVAL"),
        PENDING_3RD_PARTY("PENDING_3RD_PARTY"),
        PENDING("PENDING"),
        CONFIRMING("CONFIRMING"),
        CONFIRMED("CONFIRMED"),
        COMPLETED("COMPLETED"),
        PARTIALLY_COMPLETED("PARTIALLY_COMPLETED"),
        PENDING_AML_SCREENING("PENDING_AML_SCREENING"),
        CANCELLING("CANCELLING"),
        CANCELLED("CANCELLED"),
        REJECTED("REJECTED"),
        BLOCKED("BLOCKED"),
        FAILED("FAILED"),
        TIMEOUT("TIMEOUT");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

