/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fireblocks.sdk.JSON;
import com.fireblocks.sdk.model.AbstractOpenApiSchema;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=TransactionRequestAmountDeserializer.class)
@JsonSerialize(using=TransactionRequestAmountSerializer.class)
public class TransactionRequestAmount
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(TransactionRequestAmount.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public TransactionRequestAmount() {
        super("oneOf", Boolean.FALSE);
    }

    public TransactionRequestAmount(BigDecimal o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public TransactionRequestAmount(String o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(BigDecimal.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(String.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be BigDecimal, String");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public BigDecimal getBigDecimal() throws ClassCastException {
        return (BigDecimal)super.getActualInstance();
    }

    public String getString() throws ClassCastException {
        return (String)super.getActualInstance();
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getActualInstance() instanceof String) {
            if (this.getActualInstance() != null) {
                joiner.add(String.format("%sone_of_0%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getActualInstance()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
            return joiner.toString();
        }
        if (this.getActualInstance() instanceof BigDecimal) {
            if (this.getActualInstance() != null) {
                joiner.add(String.format("%sone_of_1%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getActualInstance()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
            return joiner.toString();
        }
        return null;
    }

    static {
        schemas.put("BigDecimal", BigDecimal.class);
        schemas.put("String", String.class);
        JSON.registerDescendants(TransactionRequestAmount.class, Collections.unmodifiableMap(schemas));
    }

    public static class TransactionRequestAmountDeserializer
    extends StdDeserializer<TransactionRequestAmount> {
        public TransactionRequestAmountDeserializer() {
            this(TransactionRequestAmount.class);
        }

        public TransactionRequestAmountDeserializer(Class<?> vc) {
            super(vc);
        }

        public TransactionRequestAmount deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((BigDecimal.class.equals(Integer.class) || BigDecimal.class.equals(Long.class) || BigDecimal.class.equals(Float.class) || BigDecimal.class.equals(Double.class) || BigDecimal.class.equals(Boolean.class) || BigDecimal.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (BigDecimal.class.equals(Integer.class) || BigDecimal.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= (BigDecimal.class.equals(Float.class) || BigDecimal.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT;
                    attemptParsing |= BigDecimal.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= BigDecimal.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(BigDecimal.class);
                    ++match;
                    log.log(Level.FINER, "Input data matches schema 'BigDecimal'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'BigDecimal'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((String.class.equals(Integer.class) || String.class.equals(Long.class) || String.class.equals(Float.class) || String.class.equals(Double.class) || String.class.equals(Boolean.class) || String.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (String.class.equals(Integer.class) || String.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= (String.class.equals(Float.class) || String.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT;
                    attemptParsing |= String.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= String.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(String.class);
                    ++match;
                    log.log(Level.FINER, "Input data matches schema 'String'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'String'", e);
            }
            if (match == 1) {
                TransactionRequestAmount ret = new TransactionRequestAmount();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for TransactionRequestAmount: %d classes match result, expected 1", match));
        }

        public TransactionRequestAmount getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "TransactionRequestAmount cannot be null");
        }
    }

    public static class TransactionRequestAmountSerializer
    extends StdSerializer<TransactionRequestAmount> {
        public TransactionRequestAmountSerializer(Class<TransactionRequestAmount> t) {
            super(t);
        }

        public TransactionRequestAmountSerializer() {
            this(null);
        }

        public void serialize(TransactionRequestAmount value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

