/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.Account;
import com.fireblocks.sdk.model.Destination;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"amount", "assetId", "source", "destination"})
public class TransferOperationConfigParams {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_ASSET_ID = "assetId";
    private String assetId;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private Account source;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private Destination destination;

    public TransferOperationConfigParams amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferOperationConfigParams assetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    @Nullable
    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssetId() {
        return this.assetId;
    }

    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public TransferOperationConfigParams source(Account source) {
        this.source = source;
        return this;
    }

    @Nullable
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Account getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(Account source) {
        this.source = source;
    }

    public TransferOperationConfigParams destination(Destination destination) {
        this.destination = destination;
        return this;
    }

    @Nonnull
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Destination getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferOperationConfigParams transferOperationConfigParams = (TransferOperationConfigParams)o;
        return Objects.equals(this.amount, transferOperationConfigParams.amount) && Objects.equals(this.assetId, transferOperationConfigParams.assetId) && Objects.equals(this.source, transferOperationConfigParams.source) && Objects.equals(this.destination, transferOperationConfigParams.destination);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.assetId, this.source, this.destination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferOperationConfigParams {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAssetId() != null) {
            joiner.add(String.format("%sassetId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssetId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSource() != null) {
            joiner.add(this.getSource().toUrlQueryString((String)prefix + JSON_PROPERTY_SOURCE + suffix));
        }
        if (this.getDestination() != null) {
            joiner.add(this.getDestination().toUrlQueryString((String)prefix + JSON_PROPERTY_DESTINATION + suffix));
        }
        return joiner.toString();
    }
}

