/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.TransferOperationConfigParams;
import com.fireblocks.sdk.model.TransferOperationExecutionOutput;
import com.fireblocks.sdk.model.TransferOperationFailure;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"input", "output", "txId", "startedAt", "finishedAt", "failure"})
public class TransferOperationExecution {
    public static final String JSON_PROPERTY_INPUT = "input";
    private TransferOperationConfigParams input;
    public static final String JSON_PROPERTY_OUTPUT = "output";
    private TransferOperationExecutionOutput output;
    public static final String JSON_PROPERTY_TX_ID = "txId";
    private String txId;
    public static final String JSON_PROPERTY_STARTED_AT = "startedAt";
    private BigDecimal startedAt;
    public static final String JSON_PROPERTY_FINISHED_AT = "finishedAt";
    private BigDecimal finishedAt;
    public static final String JSON_PROPERTY_FAILURE = "failure";
    private TransferOperationFailure failure;

    public TransferOperationExecution input(TransferOperationConfigParams input) {
        this.input = input;
        return this;
    }

    @Nonnull
    @JsonProperty(value="input")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TransferOperationConfigParams getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInput(TransferOperationConfigParams input) {
        this.input = input;
    }

    public TransferOperationExecution output(TransferOperationExecutionOutput output) {
        this.output = output;
        return this;
    }

    @Nullable
    @JsonProperty(value="output")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferOperationExecutionOutput getOutput() {
        return this.output;
    }

    @JsonProperty(value="output")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutput(TransferOperationExecutionOutput output) {
        this.output = output;
    }

    public TransferOperationExecution txId(String txId) {
        this.txId = txId;
        return this;
    }

    @Nullable
    @JsonProperty(value="txId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTxId() {
        return this.txId;
    }

    @JsonProperty(value="txId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTxId(String txId) {
        this.txId = txId;
    }

    public TransferOperationExecution startedAt(BigDecimal startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="startedAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getStartedAt() {
        return this.startedAt;
    }

    @JsonProperty(value="startedAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartedAt(BigDecimal startedAt) {
        this.startedAt = startedAt;
    }

    public TransferOperationExecution finishedAt(BigDecimal finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="finishedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getFinishedAt() {
        return this.finishedAt;
    }

    @JsonProperty(value="finishedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFinishedAt(BigDecimal finishedAt) {
        this.finishedAt = finishedAt;
    }

    public TransferOperationExecution failure(TransferOperationFailure failure) {
        this.failure = failure;
        return this;
    }

    @Nullable
    @JsonProperty(value="failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferOperationFailure getFailure() {
        return this.failure;
    }

    @JsonProperty(value="failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailure(TransferOperationFailure failure) {
        this.failure = failure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferOperationExecution transferOperationExecution = (TransferOperationExecution)o;
        return Objects.equals(this.input, transferOperationExecution.input) && Objects.equals(this.output, transferOperationExecution.output) && Objects.equals(this.txId, transferOperationExecution.txId) && Objects.equals(this.startedAt, transferOperationExecution.startedAt) && Objects.equals(this.finishedAt, transferOperationExecution.finishedAt) && Objects.equals(this.failure, transferOperationExecution.failure);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output, this.txId, this.startedAt, this.finishedAt, this.failure);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferOperationExecution {\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        sb.append("    txId: ").append(this.toIndentedString(this.txId)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    failure: ").append(this.toIndentedString(this.failure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getInput() != null) {
            joiner.add(this.getInput().toUrlQueryString((String)prefix + JSON_PROPERTY_INPUT + suffix));
        }
        if (this.getOutput() != null) {
            joiner.add(this.getOutput().toUrlQueryString((String)prefix + JSON_PROPERTY_OUTPUT + suffix));
        }
        if (this.getTxId() != null) {
            joiner.add(String.format("%stxId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTxId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStartedAt() != null) {
            joiner.add(String.format("%sstartedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFinishedAt() != null) {
            joiner.add(String.format("%sfinishedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFinishedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFailure() != null) {
            joiner.add(this.getFailure().toUrlQueryString((String)prefix + JSON_PROPERTY_FAILURE + suffix));
        }
        return joiner.toString();
    }
}

