/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"reason", "data"})
public class TransferValidationFailure {
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;
    public static final String JSON_PROPERTY_DATA = "data";
    private Map<String, Object> data = new HashMap<String, Object>();

    public TransferValidationFailure reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @Nonnull
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public TransferValidationFailure data(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public TransferValidationFailure putDataItem(String key, Object dataItem) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, dataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferValidationFailure transferValidationFailure = (TransferValidationFailure)o;
        return Objects.equals((Object)this.reason, (Object)transferValidationFailure.reason) && Objects.equals(this.data, transferValidationFailure.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.data});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferValidationFailure {\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getReason() != null) {
            joiner.add(String.format("%sreason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getData() != null) {
            for (String _key : this.getData().keySet()) {
                joiner.add(String.format("%sdata%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getData().get(_key), URLEncoder.encode(String.valueOf(this.getData().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }

    public static enum ReasonEnum {
        ACCOUNT_NOT_FOUND("ACCOUNT_NOT_FOUND"),
        ACCOUNT_TYPE_NOT_SUPPORTED("ACCOUNT_TYPE_NOT_SUPPORTED"),
        INSUFFICIENT_BALANCE("INSUFFICIENT_BALANCE"),
        ASSET_NOT_FOUND("ASSET_NOT_FOUND"),
        ASSETS_CONTINUITY_MISMATCH("ASSETS_CONTINUITY_MISMATCH"),
        EXCHANGE_BASKETS_MISMATCH("EXCHANGE_BASKETS_MISMATCH"),
        ACCOUNTS_CONTINUITY_MISMATCH("ACCOUNTS_CONTINUITY_MISMATCH"),
        ONE_TIME_ADDRESS_CONTINUITY_NOT_ALLOWED("ONE_TIME_ADDRESS_CONTINUITY_NOT_ALLOWED"),
        EQUAL_ACCOUNTS_NOT_ALLOWED("EQUAL_ACCOUNTS_NOT_ALLOWED"),
        EQUAL_ASSETS_NOT_ALLOWED("EQUAL_ASSETS_NOT_ALLOWED"),
        INVALID_AMOUNT("INVALID_AMOUNT"),
        UNMANAGED_WALLET_AS_SOURCE_NOT_ALLOWED("UNMANAGED_WALLET_AS_SOURCE_NOT_ALLOWED"),
        MANAGED_OPERATION_PARAMS_INVALID_SCHEMA("MANAGED_OPERATION_PARAMS_INVALID_SCHEMA");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

