/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"street", "city", "state", "postalCode"})
public class TravelRuleAddress {
    public static final String JSON_PROPERTY_STREET = "street";
    private String street;
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;

    public TravelRuleAddress street(String street) {
        this.street = street;
        return this;
    }

    @Nonnull
    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStreet() {
        return this.street;
    }

    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStreet(String street) {
        this.street = street;
    }

    public TravelRuleAddress city(String city) {
        this.city = city;
        return this;
    }

    @Nonnull
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCity(String city) {
        this.city = city;
    }

    public TravelRuleAddress state(String state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(String state) {
        this.state = state;
    }

    public TravelRuleAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TravelRuleAddress travelRuleAddress = (TravelRuleAddress)o;
        return Objects.equals(this.street, travelRuleAddress.street) && Objects.equals(this.city, travelRuleAddress.city) && Objects.equals(this.state, travelRuleAddress.state) && Objects.equals(this.postalCode, travelRuleAddress.postalCode);
    }

    public int hashCode() {
        return Objects.hash(this.street, this.city, this.state, this.postalCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TravelRuleAddress {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getStreet() != null) {
            joiner.add(String.format("%sstreet%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStreet()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCity() != null) {
            joiner.add(String.format("%scity%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCity()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getState() != null) {
            joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getState()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPostalCode() != null) {
            joiner.add(String.format("%spostalCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPostalCode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

