/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.WalletAsset;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "name", "customerRefId", "assets"})
public class UnmanagedWallet {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CUSTOMER_REF_ID = "customerRefId";
    private String customerRefId;
    public static final String JSON_PROPERTY_ASSETS = "assets";
    private List<WalletAsset> assets = new ArrayList<WalletAsset>();

    public UnmanagedWallet id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public UnmanagedWallet name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public UnmanagedWallet customerRefId(String customerRefId) {
        this.customerRefId = customerRefId;
        return this;
    }

    @Nullable
    @JsonProperty(value="customerRefId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerRefId() {
        return this.customerRefId;
    }

    @JsonProperty(value="customerRefId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerRefId(String customerRefId) {
        this.customerRefId = customerRefId;
    }

    public UnmanagedWallet assets(List<WalletAsset> assets) {
        this.assets = assets;
        return this;
    }

    public UnmanagedWallet addAssetsItem(WalletAsset assetsItem) {
        if (this.assets == null) {
            this.assets = new ArrayList<WalletAsset>();
        }
        this.assets.add(assetsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<WalletAsset> getAssets() {
        return this.assets;
    }

    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssets(List<WalletAsset> assets) {
        this.assets = assets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnmanagedWallet unmanagedWallet = (UnmanagedWallet)o;
        return Objects.equals(this.id, unmanagedWallet.id) && Objects.equals(this.name, unmanagedWallet.name) && Objects.equals(this.customerRefId, unmanagedWallet.customerRefId) && Objects.equals(this.assets, unmanagedWallet.assets);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.customerRefId, this.assets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnmanagedWallet {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    customerRefId: ").append(this.toIndentedString(this.customerRefId)).append("\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCustomerRefId() != null) {
            joiner.add(String.format("%scustomerRefId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCustomerRefId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAssets() != null) {
            for (int i = 0; i < this.getAssets().size(); ++i) {
                if (this.getAssets().get(i) == null) continue;
                joiner.add(this.getAssets().get(i).toUrlQueryString(String.format("%sassets%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

