/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.UnspentInput;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"input", "address", "amount", "confirmations", "status"})
public class UnspentInputsResponse {
    public static final String JSON_PROPERTY_INPUT = "input";
    private UnspentInput input;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_CONFIRMATIONS = "confirmations";
    private BigDecimal confirmations;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;

    public UnspentInputsResponse input(UnspentInput input) {
        this.input = input;
        return this;
    }

    @Nullable
    @JsonProperty(value="input")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UnspentInput getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInput(UnspentInput input) {
        this.input = input;
    }

    public UnspentInputsResponse address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(String address) {
        this.address = address;
    }

    public UnspentInputsResponse amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public UnspentInputsResponse confirmations(BigDecimal confirmations) {
        this.confirmations = confirmations;
        return this;
    }

    @Nullable
    @JsonProperty(value="confirmations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getConfirmations() {
        return this.confirmations;
    }

    @JsonProperty(value="confirmations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfirmations(BigDecimal confirmations) {
        this.confirmations = confirmations;
    }

    public UnspentInputsResponse status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnspentInputsResponse unspentInputsResponse = (UnspentInputsResponse)o;
        return Objects.equals(this.input, unspentInputsResponse.input) && Objects.equals(this.address, unspentInputsResponse.address) && Objects.equals(this.amount, unspentInputsResponse.amount) && Objects.equals(this.confirmations, unspentInputsResponse.confirmations) && Objects.equals(this.status, unspentInputsResponse.status);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.address, this.amount, this.confirmations, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnspentInputsResponse {\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    confirmations: ").append(this.toIndentedString(this.confirmations)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getInput() != null) {
            joiner.add(this.getInput().toUrlQueryString((String)prefix + JSON_PROPERTY_INPUT + suffix));
        }
        if (this.getAddress() != null) {
            joiner.add(String.format("%saddress%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAddress()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getConfirmations() != null) {
            joiner.add(String.format("%sconfirmations%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getConfirmations()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

