/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.VaultAsset;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "name", "assets", "hiddenOnUI", "customerRefId", "autoFuel"})
public class VaultAccount {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ASSETS = "assets";
    private List<VaultAsset> assets;
    public static final String JSON_PROPERTY_HIDDEN_ON_U_I = "hiddenOnUI";
    private Boolean hiddenOnUI;
    public static final String JSON_PROPERTY_CUSTOMER_REF_ID = "customerRefId";
    private String customerRefId;
    public static final String JSON_PROPERTY_AUTO_FUEL = "autoFuel";
    private Boolean autoFuel;

    public VaultAccount id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public VaultAccount name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public VaultAccount assets(List<VaultAsset> assets) {
        this.assets = assets;
        return this;
    }

    public VaultAccount addAssetsItem(VaultAsset assetsItem) {
        if (this.assets == null) {
            this.assets = new ArrayList<VaultAsset>();
        }
        this.assets.add(assetsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VaultAsset> getAssets() {
        return this.assets;
    }

    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssets(List<VaultAsset> assets) {
        this.assets = assets;
    }

    public VaultAccount hiddenOnUI(Boolean hiddenOnUI) {
        this.hiddenOnUI = hiddenOnUI;
        return this;
    }

    @Nullable
    @JsonProperty(value="hiddenOnUI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHiddenOnUI() {
        return this.hiddenOnUI;
    }

    @JsonProperty(value="hiddenOnUI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHiddenOnUI(Boolean hiddenOnUI) {
        this.hiddenOnUI = hiddenOnUI;
    }

    public VaultAccount customerRefId(String customerRefId) {
        this.customerRefId = customerRefId;
        return this;
    }

    @Nullable
    @JsonProperty(value="customerRefId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerRefId() {
        return this.customerRefId;
    }

    @JsonProperty(value="customerRefId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerRefId(String customerRefId) {
        this.customerRefId = customerRefId;
    }

    public VaultAccount autoFuel(Boolean autoFuel) {
        this.autoFuel = autoFuel;
        return this;
    }

    @Nullable
    @JsonProperty(value="autoFuel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoFuel() {
        return this.autoFuel;
    }

    @JsonProperty(value="autoFuel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoFuel(Boolean autoFuel) {
        this.autoFuel = autoFuel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultAccount vaultAccount = (VaultAccount)o;
        return Objects.equals(this.id, vaultAccount.id) && Objects.equals(this.name, vaultAccount.name) && Objects.equals(this.assets, vaultAccount.assets) && Objects.equals(this.hiddenOnUI, vaultAccount.hiddenOnUI) && Objects.equals(this.customerRefId, vaultAccount.customerRefId) && Objects.equals(this.autoFuel, vaultAccount.autoFuel);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.assets, this.hiddenOnUI, this.customerRefId, this.autoFuel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VaultAccount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("    hiddenOnUI: ").append(this.toIndentedString(this.hiddenOnUI)).append("\n");
        sb.append("    customerRefId: ").append(this.toIndentedString(this.customerRefId)).append("\n");
        sb.append("    autoFuel: ").append(this.toIndentedString(this.autoFuel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAssets() != null) {
            for (int i = 0; i < this.getAssets().size(); ++i) {
                if (this.getAssets().get(i) == null) continue;
                joiner.add(this.getAssets().get(i).toUrlQueryString(String.format("%sassets%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getHiddenOnUI() != null) {
            joiner.add(String.format("%shiddenOnUI%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getHiddenOnUI()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCustomerRefId() != null) {
            joiner.add(String.format("%scustomerRefId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCustomerRefId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAutoFuel() != null) {
            joiner.add(String.format("%sautoFuel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAutoFuel()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

