/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.VaultAccount;
import com.fireblocks.sdk.model.VaultAccountsPagedResponsePaging;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"accounts", "paging", "previousUrl", "nextUrl"})
public class VaultAccountsPagedResponse {
    public static final String JSON_PROPERTY_ACCOUNTS = "accounts";
    private List<VaultAccount> accounts;
    public static final String JSON_PROPERTY_PAGING = "paging";
    private VaultAccountsPagedResponsePaging paging;
    public static final String JSON_PROPERTY_PREVIOUS_URL = "previousUrl";
    private String previousUrl;
    public static final String JSON_PROPERTY_NEXT_URL = "nextUrl";
    private String nextUrl;

    public VaultAccountsPagedResponse accounts(List<VaultAccount> accounts) {
        this.accounts = accounts;
        return this;
    }

    public VaultAccountsPagedResponse addAccountsItem(VaultAccount accountsItem) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<VaultAccount>();
        }
        this.accounts.add(accountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VaultAccount> getAccounts() {
        return this.accounts;
    }

    @JsonProperty(value="accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccounts(List<VaultAccount> accounts) {
        this.accounts = accounts;
    }

    public VaultAccountsPagedResponse paging(VaultAccountsPagedResponsePaging paging) {
        this.paging = paging;
        return this;
    }

    @Nullable
    @JsonProperty(value="paging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VaultAccountsPagedResponsePaging getPaging() {
        return this.paging;
    }

    @JsonProperty(value="paging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaging(VaultAccountsPagedResponsePaging paging) {
        this.paging = paging;
    }

    public VaultAccountsPagedResponse previousUrl(String previousUrl) {
        this.previousUrl = previousUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="previousUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPreviousUrl() {
        return this.previousUrl;
    }

    @JsonProperty(value="previousUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreviousUrl(String previousUrl) {
        this.previousUrl = previousUrl;
    }

    public VaultAccountsPagedResponse nextUrl(String nextUrl) {
        this.nextUrl = nextUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="nextUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNextUrl() {
        return this.nextUrl;
    }

    @JsonProperty(value="nextUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNextUrl(String nextUrl) {
        this.nextUrl = nextUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultAccountsPagedResponse vaultAccountsPagedResponse = (VaultAccountsPagedResponse)o;
        return Objects.equals(this.accounts, vaultAccountsPagedResponse.accounts) && Objects.equals(this.paging, vaultAccountsPagedResponse.paging) && Objects.equals(this.previousUrl, vaultAccountsPagedResponse.previousUrl) && Objects.equals(this.nextUrl, vaultAccountsPagedResponse.nextUrl);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.paging, this.previousUrl, this.nextUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VaultAccountsPagedResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("    previousUrl: ").append(this.toIndentedString(this.previousUrl)).append("\n");
        sb.append("    nextUrl: ").append(this.toIndentedString(this.nextUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAccounts() != null) {
            for (int i = 0; i < this.getAccounts().size(); ++i) {
                if (this.getAccounts().get(i) == null) continue;
                joiner.add(this.getAccounts().get(i).toUrlQueryString(String.format("%saccounts%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getPaging() != null) {
            joiner.add(this.getPaging().toUrlQueryString((String)prefix + JSON_PROPERTY_PAGING + suffix));
        }
        if (this.getPreviousUrl() != null) {
            joiner.add(String.format("%spreviousUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPreviousUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getNextUrl() != null) {
            joiner.add(String.format("%snextUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNextUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

