/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotMetadata;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.GetSnapshotRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.Snapshot;
import com.google.bigtable.admin.v2.SnapshotTableMetadata;
import com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStub;
import com.google.cloud.bigtable.admin.v2.stub.GrpcBigtableTableAdminStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class BigtableTableAdminStubSettings
extends StubSettings<BigtableTableAdminStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigtable.admin").add((Object)"https://www.googleapis.com/auth/bigtable.admin.cluster").add((Object)"https://www.googleapis.com/auth/bigtable.admin.instance").add((Object)"https://www.googleapis.com/auth/bigtable.admin.table").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.admin").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.admin.cluster").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.admin.table").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final UnaryCallSettings<CreateTableRequest, Table> createTableSettings;
    private final UnaryCallSettings<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotSettings;
    private final OperationCallSettings<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationSettings;
    private final PagedCallSettings<ListTablesRequest, ListTablesResponse, BigtableTableAdminClient.ListTablesPagedResponse> listTablesSettings;
    private final UnaryCallSettings<GetTableRequest, Table> getTableSettings;
    private final UnaryCallSettings<DeleteTableRequest, Empty> deleteTableSettings;
    private final UnaryCallSettings<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesSettings;
    private final UnaryCallSettings<DropRowRangeRequest, Empty> dropRowRangeSettings;
    private final UnaryCallSettings<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenSettings;
    private final UnaryCallSettings<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencySettings;
    private final UnaryCallSettings<SnapshotTableRequest, Operation> snapshotTableSettings;
    private final OperationCallSettings<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationSettings;
    private final UnaryCallSettings<GetSnapshotRequest, Snapshot> getSnapshotSettings;
    private final PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, BigtableTableAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
    private final UnaryCallSettings<DeleteSnapshotRequest, Empty> deleteSnapshotSettings;
    private static final PagedListDescriptor<ListTablesRequest, ListTablesResponse, Table> LIST_TABLES_PAGE_STR_DESC = new PagedListDescriptor<ListTablesRequest, ListTablesResponse, Table>(){

        public String emptyToken() {
            return "";
        }

        public ListTablesRequest injectToken(ListTablesRequest payload, String token) {
            return ListTablesRequest.newBuilder((ListTablesRequest)payload).setPageToken(token).build();
        }

        public ListTablesRequest injectPageSize(ListTablesRequest payload, int pageSize) {
            throw new UnsupportedOperationException("page size is not supported by this API method");
        }

        public Integer extractPageSize(ListTablesRequest payload) {
            throw new UnsupportedOperationException("page size is not supported by this API method");
        }

        public String extractNextToken(ListTablesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Table> extractResources(ListTablesResponse payload) {
            return payload.getTablesList();
        }
    };
    private static final PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> LIST_SNAPSHOTS_PAGE_STR_DESC = new PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>(){

        public String emptyToken() {
            return "";
        }

        public ListSnapshotsRequest injectToken(ListSnapshotsRequest payload, String token) {
            return ListSnapshotsRequest.newBuilder((ListSnapshotsRequest)payload).setPageToken(token).build();
        }

        public ListSnapshotsRequest injectPageSize(ListSnapshotsRequest payload, int pageSize) {
            return ListSnapshotsRequest.newBuilder((ListSnapshotsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSnapshotsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSnapshotsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Snapshot> extractResources(ListSnapshotsResponse payload) {
            return payload.getSnapshotsList();
        }
    };
    private static final PagedListResponseFactory<ListTablesRequest, ListTablesResponse, BigtableTableAdminClient.ListTablesPagedResponse> LIST_TABLES_PAGE_STR_FACT = new PagedListResponseFactory<ListTablesRequest, ListTablesResponse, BigtableTableAdminClient.ListTablesPagedResponse>(){

        public ApiFuture<BigtableTableAdminClient.ListTablesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTablesRequest, ListTablesResponse> callable, ListTablesRequest request, ApiCallContext context, ApiFuture<ListTablesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TABLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BigtableTableAdminClient.ListTablesPagedResponse.createAsync((PageContext<ListTablesRequest, ListTablesResponse, Table>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, BigtableTableAdminClient.ListSnapshotsPagedResponse> LIST_SNAPSHOTS_PAGE_STR_FACT = new PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, BigtableTableAdminClient.ListSnapshotsPagedResponse>(){

        public ApiFuture<BigtableTableAdminClient.ListSnapshotsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> callable, ListSnapshotsRequest request, ApiCallContext context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SNAPSHOTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BigtableTableAdminClient.ListSnapshotsPagedResponse.createAsync((PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateTableRequest, Table> createTableSettings() {
        return this.createTableSettings;
    }

    public UnaryCallSettings<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotSettings() {
        return this.createTableFromSnapshotSettings;
    }

    public OperationCallSettings<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationSettings() {
        return this.createTableFromSnapshotOperationSettings;
    }

    public PagedCallSettings<ListTablesRequest, ListTablesResponse, BigtableTableAdminClient.ListTablesPagedResponse> listTablesSettings() {
        return this.listTablesSettings;
    }

    public UnaryCallSettings<GetTableRequest, Table> getTableSettings() {
        return this.getTableSettings;
    }

    public UnaryCallSettings<DeleteTableRequest, Empty> deleteTableSettings() {
        return this.deleteTableSettings;
    }

    public UnaryCallSettings<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesSettings() {
        return this.modifyColumnFamiliesSettings;
    }

    public UnaryCallSettings<DropRowRangeRequest, Empty> dropRowRangeSettings() {
        return this.dropRowRangeSettings;
    }

    public UnaryCallSettings<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenSettings() {
        return this.generateConsistencyTokenSettings;
    }

    public UnaryCallSettings<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencySettings() {
        return this.checkConsistencySettings;
    }

    public UnaryCallSettings<SnapshotTableRequest, Operation> snapshotTableSettings() {
        return this.snapshotTableSettings;
    }

    public OperationCallSettings<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationSettings() {
        return this.snapshotTableOperationSettings;
    }

    public UnaryCallSettings<GetSnapshotRequest, Snapshot> getSnapshotSettings() {
        return this.getSnapshotSettings;
    }

    public PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, BigtableTableAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
        return this.listSnapshotsSettings;
    }

    public UnaryCallSettings<DeleteSnapshotRequest, Empty> deleteSnapshotSettings() {
        return this.deleteSnapshotSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BigtableTableAdminStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBigtableTableAdminStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "bigtableadmin.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BigtableTableAdminStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BigtableTableAdminStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BigtableTableAdminStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTableSettings = settingsBuilder.createTableSettings().build();
        this.createTableFromSnapshotSettings = settingsBuilder.createTableFromSnapshotSettings().build();
        this.createTableFromSnapshotOperationSettings = settingsBuilder.createTableFromSnapshotOperationSettings().build();
        this.listTablesSettings = settingsBuilder.listTablesSettings().build();
        this.getTableSettings = settingsBuilder.getTableSettings().build();
        this.deleteTableSettings = settingsBuilder.deleteTableSettings().build();
        this.modifyColumnFamiliesSettings = settingsBuilder.modifyColumnFamiliesSettings().build();
        this.dropRowRangeSettings = settingsBuilder.dropRowRangeSettings().build();
        this.generateConsistencyTokenSettings = settingsBuilder.generateConsistencyTokenSettings().build();
        this.checkConsistencySettings = settingsBuilder.checkConsistencySettings().build();
        this.snapshotTableSettings = settingsBuilder.snapshotTableSettings().build();
        this.snapshotTableOperationSettings = settingsBuilder.snapshotTableOperationSettings().build();
        this.getSnapshotSettings = settingsBuilder.getSnapshotSettings().build();
        this.listSnapshotsSettings = settingsBuilder.listSnapshotsSettings().build();
        this.deleteSnapshotSettings = settingsBuilder.deleteSnapshotSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BigtableTableAdminStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateTableRequest, Table> createTableSettings;
        private final UnaryCallSettings.Builder<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotSettings;
        private final OperationCallSettings.Builder<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationSettings;
        private final PagedCallSettings.Builder<ListTablesRequest, ListTablesResponse, BigtableTableAdminClient.ListTablesPagedResponse> listTablesSettings;
        private final UnaryCallSettings.Builder<GetTableRequest, Table> getTableSettings;
        private final UnaryCallSettings.Builder<DeleteTableRequest, Empty> deleteTableSettings;
        private final UnaryCallSettings.Builder<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesSettings;
        private final UnaryCallSettings.Builder<DropRowRangeRequest, Empty> dropRowRangeSettings;
        private final UnaryCallSettings.Builder<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenSettings;
        private final UnaryCallSettings.Builder<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencySettings;
        private final UnaryCallSettings.Builder<SnapshotTableRequest, Operation> snapshotTableSettings;
        private final OperationCallSettings.Builder<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationSettings;
        private final UnaryCallSettings.Builder<GetSnapshotRequest, Snapshot> getSnapshotSettings;
        private final PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, BigtableTableAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
        private final UnaryCallSettings.Builder<DeleteSnapshotRequest, Empty> deleteSnapshotSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTableFromSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTableFromSnapshotOperationSettings = OperationCallSettings.newBuilder();
            this.listTablesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TABLES_PAGE_STR_FACT);
            this.getTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.modifyColumnFamiliesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.dropRowRangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateConsistencyTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.checkConsistencySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.snapshotTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.snapshotTableOperationSettings = OperationCallSettings.newBuilder();
            this.getSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSnapshotsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SNAPSHOTS_PAGE_STR_FACT);
            this.deleteSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTableSettings, this.createTableFromSnapshotSettings, this.listTablesSettings, this.getTableSettings, this.deleteTableSettings, this.modifyColumnFamiliesSettings, this.dropRowRangeSettings, this.generateConsistencyTokenSettings, this.checkConsistencySettings, this.snapshotTableSettings, this.getSnapshotSettings, this.listSnapshotsSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteSnapshotSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BigtableTableAdminStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BigtableTableAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BigtableTableAdminStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BigtableTableAdminStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"create_table"));
            builder.createTableFromSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTablesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.modifyColumnFamiliesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.dropRowRangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"drop_row_range"));
            builder.generateConsistencyTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.checkConsistencySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.snapshotTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSnapshotsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createTableFromSnapshotOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Table.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateTableFromSnapshotMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.snapshotTableOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Snapshot.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(SnapshotTableMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(BigtableTableAdminStubSettings settings) {
            super((StubSettings)settings);
            this.createTableSettings = settings.createTableSettings.toBuilder();
            this.createTableFromSnapshotSettings = settings.createTableFromSnapshotSettings.toBuilder();
            this.createTableFromSnapshotOperationSettings = settings.createTableFromSnapshotOperationSettings.toBuilder();
            this.listTablesSettings = settings.listTablesSettings.toBuilder();
            this.getTableSettings = settings.getTableSettings.toBuilder();
            this.deleteTableSettings = settings.deleteTableSettings.toBuilder();
            this.modifyColumnFamiliesSettings = settings.modifyColumnFamiliesSettings.toBuilder();
            this.dropRowRangeSettings = settings.dropRowRangeSettings.toBuilder();
            this.generateConsistencyTokenSettings = settings.generateConsistencyTokenSettings.toBuilder();
            this.checkConsistencySettings = settings.checkConsistencySettings.toBuilder();
            this.snapshotTableSettings = settings.snapshotTableSettings.toBuilder();
            this.snapshotTableOperationSettings = settings.snapshotTableOperationSettings.toBuilder();
            this.getSnapshotSettings = settings.getSnapshotSettings.toBuilder();
            this.listSnapshotsSettings = settings.listSnapshotsSettings.toBuilder();
            this.deleteSnapshotSettings = settings.deleteSnapshotSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTableSettings, this.createTableFromSnapshotSettings, this.listTablesSettings, this.getTableSettings, this.deleteTableSettings, this.modifyColumnFamiliesSettings, this.dropRowRangeSettings, this.generateConsistencyTokenSettings, this.checkConsistencySettings, this.snapshotTableSettings, this.getSnapshotSettings, this.listSnapshotsSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteSnapshotSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateTableRequest, Table> createTableSettings() {
            return this.createTableSettings;
        }

        public UnaryCallSettings.Builder<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotSettings() {
            return this.createTableFromSnapshotSettings;
        }

        public OperationCallSettings.Builder<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationSettings() {
            return this.createTableFromSnapshotOperationSettings;
        }

        public PagedCallSettings.Builder<ListTablesRequest, ListTablesResponse, BigtableTableAdminClient.ListTablesPagedResponse> listTablesSettings() {
            return this.listTablesSettings;
        }

        public UnaryCallSettings.Builder<GetTableRequest, Table> getTableSettings() {
            return this.getTableSettings;
        }

        public UnaryCallSettings.Builder<DeleteTableRequest, Empty> deleteTableSettings() {
            return this.deleteTableSettings;
        }

        public UnaryCallSettings.Builder<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesSettings() {
            return this.modifyColumnFamiliesSettings;
        }

        public UnaryCallSettings.Builder<DropRowRangeRequest, Empty> dropRowRangeSettings() {
            return this.dropRowRangeSettings;
        }

        public UnaryCallSettings.Builder<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenSettings() {
            return this.generateConsistencyTokenSettings;
        }

        public UnaryCallSettings.Builder<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencySettings() {
            return this.checkConsistencySettings;
        }

        public UnaryCallSettings.Builder<SnapshotTableRequest, Operation> snapshotTableSettings() {
            return this.snapshotTableSettings;
        }

        public OperationCallSettings.Builder<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationSettings() {
            return this.snapshotTableOperationSettings;
        }

        public UnaryCallSettings.Builder<GetSnapshotRequest, Snapshot> getSnapshotSettings() {
            return this.getSnapshotSettings;
        }

        public PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, BigtableTableAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
            return this.listSnapshotsSettings;
        }

        public UnaryCallSettings.Builder<DeleteSnapshotRequest, Empty> deleteSnapshotSettings() {
            return this.deleteSnapshotSettings;
        }

        public BigtableTableAdminStubSettings build() throws IOException {
            return new BigtableTableAdminStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)130000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)130000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"create_table", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)900000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)900000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"drop_row_range", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

