/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2;

import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.InstanceName;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

public class BigtableDataSettings
extends ClientSettings<BigtableDataSettings> {
    private BigtableDataSettings(Builder builder) throws IOException {
        super((ClientSettings.Builder)builder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public InstanceName getInstanceName() {
        return this.getTypedStubSettings().getInstanceName();
    }

    public String getAppProfileId() {
        return this.getTypedStubSettings().getAppProfileId();
    }

    public ServerStreamingCallSettings<Query, Row> readRowsSettings() {
        return this.getTypedStubSettings().readRowsSettings();
    }

    public UnaryCallSettings<String, List<KeyOffset>> sampleRowKeysSettings() {
        return this.getTypedStubSettings().sampleRowKeysSettings();
    }

    public UnaryCallSettings<RowMutation, Void> mutateRowSettings() {
        return this.getTypedStubSettings().mutateRowSettings();
    }

    public BatchingCallSettings<RowMutation, Void> bulkMutationsSettings() {
        return this.getTypedStubSettings().bulkMutateRowsSettings();
    }

    public UnaryCallSettings<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
        return this.getTypedStubSettings().checkAndMutateRowSettings();
    }

    public UnaryCallSettings<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
        return this.getTypedStubSettings().readModifyWriteRowSettings();
    }

    EnhancedBigtableStubSettings getTypedStubSettings() {
        return (EnhancedBigtableStubSettings)this.getStubSettings();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends ClientSettings.Builder<BigtableDataSettings, Builder> {
        private Builder() {
            super((StubSettings.Builder)EnhancedBigtableStubSettings.newBuilder());
        }

        private Builder(BigtableDataSettings settings) {
            super((ClientSettings)settings);
        }

        public Builder setInstanceName(@Nonnull InstanceName instanceName) {
            this.getTypedStubSettings().setInstanceName(instanceName);
            return this;
        }

        public InstanceName getInstanceName() {
            return this.getTypedStubSettings().getInstanceName();
        }

        public Builder setAppProfileId(@Nonnull String appProfileId) {
            this.getTypedStubSettings().setAppProfileId(appProfileId);
            return this;
        }

        public String getAppProfileId() {
            return this.getTypedStubSettings().getAppProfileId();
        }

        public ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings() {
            return this.getTypedStubSettings().readRowsSettings();
        }

        public UnaryCallSettings.Builder<String, List<KeyOffset>> sampleRowKeysSettings() {
            return this.getTypedStubSettings().sampleRowKeysSettings();
        }

        public UnaryCallSettings.Builder<RowMutation, Void> mutateRowSettings() {
            return this.getTypedStubSettings().mutateRowSettings();
        }

        public BatchingCallSettings.Builder<RowMutation, Void> bulkMutationsSettings() {
            return this.getTypedStubSettings().bulkMutateRowsSettings();
        }

        public UnaryCallSettings.Builder<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
            return this.getTypedStubSettings().checkAndMutateRowSettings();
        }

        public UnaryCallSettings.Builder<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
            return this.getTypedStubSettings().readModifyWriteRowSettings();
        }

        private EnhancedBigtableStubSettings.Builder getTypedStubSettings() {
            return (EnhancedBigtableStubSettings.Builder)this.getStubSettings();
        }

        public BigtableDataSettings build() throws IOException {
            return new BigtableDataSettings(this);
        }
    }
}

