/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.threeten.bp.Duration;

@BetaApi(value="This surface is likely to change as the batching surface evolves.")
public final class BulkMutationBatcher
implements AutoCloseable {
    private final UnaryCallable<RowMutation, Void> callable;
    private final Object lock = new Object();
    private final AtomicLong numOutstanding = new AtomicLong();
    private long numFailures;
    private boolean closed;

    @InternalApi
    public BulkMutationBatcher(UnaryCallable<RowMutation, Void> callable) {
        this.callable = callable;
    }

    @Override
    public void close() throws InterruptedException, TimeoutException {
        this.close(Duration.ofMinutes((long)10L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Duration duration) throws InterruptedException, TimeoutException {
        this.closed = true;
        long deadlineMs = System.currentTimeMillis() + duration.toMillis();
        Object object = this.lock;
        synchronized (object) {
            while (this.numOutstanding.get() > 0L) {
                long waitMs = deadlineMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    throw new TimeoutException("Timed out waiting outstanding mutations to finish");
                }
                this.lock.wait(waitMs);
            }
            if (this.numFailures > 0L) {
                throw new BulkMutationFailure(this.numFailures);
            }
        }
    }

    public ApiFuture<Void> add(RowMutation rowMutation) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"BulkMutations has been closed");
        this.numOutstanding.incrementAndGet();
        ApiFuture future = this.callable.futureCall((Object)rowMutation);
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new ApiFutureCallback<Void>(){

            public void onFailure(Throwable throwable) {
                BulkMutationBatcher.this.onMutationComplete(false);
            }

            public void onSuccess(Void aVoid) {
                BulkMutationBatcher.this.onMutationComplete(true);
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMutationComplete(boolean isOk) {
        if (!isOk) {
            ++this.numFailures;
        }
        if (this.numOutstanding.decrementAndGet() == 0L) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    public static class BulkMutationFailure
    extends RuntimeException {
        BulkMutationFailure(long numFailures) {
            super("Failed to commit " + numFailures + " mutations");
        }
    }
}

