/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.TableName;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class RowMutation
implements MutationApi<RowMutation>,
Serializable {
    private static final long serialVersionUID = 6529002234913236318L;
    private final String tableId;
    private final ByteString key;
    private final Mutation mutation;

    private RowMutation(String tableId, ByteString key) {
        this.tableId = tableId;
        this.key = key;
        this.mutation = Mutation.create();
    }

    public static RowMutation create(@Nonnull String tableId, @Nonnull String key) {
        return RowMutation.create(tableId, ByteString.copyFromUtf8((String)key));
    }

    public static RowMutation create(@Nonnull String tableId, @Nonnull ByteString key) {
        return new RowMutation(tableId, key);
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull String qualifier, @Nonnull String value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull String qualifier, long timestamp, @Nonnull String value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull ByteString value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, @Nonnull ByteString value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutation deleteCells(@Nonnull String familyName, @Nonnull String qualifier) {
        this.mutation.deleteCells(familyName, qualifier);
        return this;
    }

    @Override
    public RowMutation deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier) {
        this.mutation.deleteCells(familyName, qualifier);
        return this;
    }

    @Override
    public RowMutation deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull Range.TimestampRange timestampRange) {
        this.mutation.deleteCells(familyName, qualifier, timestampRange);
        return this;
    }

    @Override
    public RowMutation deleteFamily(@Nonnull String familyName) {
        this.mutation.deleteFamily(familyName);
        return this;
    }

    @Override
    public RowMutation deleteRow() {
        this.mutation.deleteRow();
        return this;
    }

    @InternalApi
    public MutateRowRequest toProto(RequestContext requestContext) {
        TableName tableName = TableName.of((String)requestContext.getInstanceName().getProject(), (String)requestContext.getInstanceName().getInstance(), (String)this.tableId);
        return MutateRowRequest.newBuilder().setAppProfileId(requestContext.getAppProfileId()).setTableName(tableName.toString()).setRowKey(this.key).addAllMutations(this.mutation.getMutations()).build();
    }

    @InternalApi
    public MutateRowsRequest toBulkProto(RequestContext requestContext) {
        TableName tableName = TableName.of((String)requestContext.getInstanceName().getProject(), (String)requestContext.getInstanceName().getInstance(), (String)this.tableId);
        return MutateRowsRequest.newBuilder().setAppProfileId(requestContext.getAppProfileId()).setTableName(tableName.toString()).addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(this.key).addAllMutations(this.mutation.getMutations()).build()).build();
    }
}

