/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.bigtable.data.v2.internal.DummyBatchingDescriptor;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.InstanceName;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.BigtableStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.threeten.bp.Duration;

@InternalApi
public class EnhancedBigtableStubSettings
extends StubSettings<EnhancedBigtableStubSettings> {
    private static final int MAX_MESSAGE_SIZE = 0x10000000;
    private static final String SERVER_DEFAULT_APP_PROFILE_ID = "";
    private static final Set<StatusCode.Code> DEFAULT_RETRY_CODES = ImmutableSet.of((Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE, (Object)StatusCode.Code.ABORTED);
    private static final RetrySettings DEFAULT_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
    private final InstanceName instanceName;
    private final String appProfileId;
    private final ServerStreamingCallSettings<Query, Row> readRowsSettings;
    private final UnaryCallSettings<String, List<KeyOffset>> sampleRowKeysSettings;
    private final UnaryCallSettings<RowMutation, Void> mutateRowSettings;
    private final BatchingCallSettings<RowMutation, Void> bulkMutateRowsSettings;
    private final UnaryCallSettings<ConditionalRowMutation, Boolean> checkAndMutateRowSettings;
    private final UnaryCallSettings<ReadModifyWriteRow, Row> readModifyWriteRowSettings;

    private EnhancedBigtableStubSettings(Builder builder) {
        super((StubSettings.Builder)builder);
        this.instanceName = builder.instanceName;
        this.appProfileId = builder.appProfileId;
        this.readRowsSettings = builder.readRowsSettings.build();
        this.sampleRowKeysSettings = builder.sampleRowKeysSettings.build();
        this.mutateRowSettings = builder.mutateRowSettings.build();
        this.bulkMutateRowsSettings = builder.bulkMutateRowsSettings.build();
        this.checkAndMutateRowSettings = builder.checkAndMutateRowSettings.build();
        this.readModifyWriteRowSettings = builder.readModifyWriteRowSettings.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public InstanceName getInstanceName() {
        return this.instanceName;
    }

    public String getAppProfileId() {
        return this.appProfileId;
    }

    public ServerStreamingCallSettings<Query, Row> readRowsSettings() {
        return this.readRowsSettings;
    }

    public UnaryCallSettings<String, List<KeyOffset>> sampleRowKeysSettings() {
        return this.sampleRowKeysSettings;
    }

    public UnaryCallSettings<RowMutation, Void> mutateRowSettings() {
        return this.mutateRowSettings;
    }

    public BatchingCallSettings<RowMutation, Void> bulkMutateRowsSettings() {
        return this.bulkMutateRowsSettings;
    }

    public UnaryCallSettings<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
        return this.checkAndMutateRowSettings;
    }

    public UnaryCallSettings<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
        return this.readModifyWriteRowSettings;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends StubSettings.Builder<EnhancedBigtableStubSettings, Builder> {
        private InstanceName instanceName;
        private String appProfileId;
        private final ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings;
        private final UnaryCallSettings.Builder<String, List<KeyOffset>> sampleRowKeysSettings;
        private final UnaryCallSettings.Builder<RowMutation, Void> mutateRowSettings;
        private final BatchingCallSettings.Builder<RowMutation, Void> bulkMutateRowsSettings;
        private final UnaryCallSettings.Builder<ConditionalRowMutation, Boolean> checkAndMutateRowSettings;
        private final UnaryCallSettings.Builder<ReadModifyWriteRow, Row> readModifyWriteRowSettings;

        private Builder() {
            this.appProfileId = EnhancedBigtableStubSettings.SERVER_DEFAULT_APP_PROFILE_ID;
            BigtableStubSettings.Builder baseDefaults = BigtableStubSettings.newBuilder();
            this.setEndpoint(baseDefaults.getEndpoint());
            this.setCredentialsProvider(baseDefaults.getCredentialsProvider());
            this.setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setChannelsPerCpu(2.0).setMaxInboundMessageSize(Integer.valueOf(0x10000000)).build());
            this.setStreamWatchdogCheckInterval(baseDefaults.getStreamWatchdogCheckInterval());
            this.setStreamWatchdogProvider(baseDefaults.getStreamWatchdogProvider());
            this.readRowsSettings = ServerStreamingCallSettings.newBuilder();
            this.readRowsSettings.setRetryableCodes(DEFAULT_RETRY_CODES).setRetrySettings(DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofHours((long)1L)).build()).setIdleTimeout(Duration.ofMinutes((long)5L));
            this.sampleRowKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.sampleRowKeysSettings.setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.ABORTED}).setRetrySettings(DEFAULT_RETRY_SETTINGS);
            this.mutateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.mutateRowSettings(), this.mutateRowSettings);
            this.bulkMutateRowsSettings = BatchingCallSettings.newBuilder(new DummyBatchingDescriptor()).setRetryableCodes(DEFAULT_RETRY_CODES).setRetrySettings(DEFAULT_RETRY_SETTINGS).setBatchingSettings(BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(true)).setElementCountThreshold(Long.valueOf(100L)).setRequestByteThreshold(Long.valueOf(0x1400000L)).setDelayThreshold(Duration.ofSeconds((long)1L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).setMaxOutstandingRequestBytes(Long.valueOf(0x6400000L)).setMaxOutstandingElementCount(Long.valueOf(1000L)).build()).build());
            this.checkAndMutateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.checkAndMutateRowSettings(), this.checkAndMutateRowSettings);
            this.readModifyWriteRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.readModifyWriteRowSettings(), this.readModifyWriteRowSettings);
        }

        private Builder(EnhancedBigtableStubSettings settings) {
            super((StubSettings)settings);
            this.instanceName = settings.instanceName;
            this.appProfileId = settings.appProfileId;
            this.readRowsSettings = settings.readRowsSettings.toBuilder();
            this.sampleRowKeysSettings = settings.sampleRowKeysSettings.toBuilder();
            this.mutateRowSettings = settings.mutateRowSettings.toBuilder();
            this.bulkMutateRowsSettings = settings.bulkMutateRowsSettings.toBuilder();
            this.checkAndMutateRowSettings = settings.checkAndMutateRowSettings.toBuilder();
            this.readModifyWriteRowSettings = settings.readModifyWriteRowSettings.toBuilder();
        }

        private static void copyRetrySettings(UnaryCallSettings.Builder<?, ?> source, UnaryCallSettings.Builder<?, ?> dest) {
            dest.setRetryableCodes(source.getRetryableCodes());
            dest.setRetrySettings(source.getRetrySettings());
        }

        public Builder setInstanceName(@Nonnull InstanceName instanceName) {
            Preconditions.checkNotNull((Object)instanceName);
            this.instanceName = instanceName;
            return this;
        }

        public InstanceName getInstanceName() {
            return this.instanceName;
        }

        public Builder setAppProfileId(@Nonnull String appProfileId) {
            Preconditions.checkNotNull((Object)appProfileId, (Object)"AppProfileId can't be null");
            this.appProfileId = appProfileId;
            return this;
        }

        public String getAppProfileId() {
            return this.appProfileId;
        }

        public ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings() {
            return this.readRowsSettings;
        }

        public UnaryCallSettings.Builder<String, List<KeyOffset>> sampleRowKeysSettings() {
            return this.sampleRowKeysSettings;
        }

        public UnaryCallSettings.Builder<RowMutation, Void> mutateRowSettings() {
            return this.mutateRowSettings;
        }

        public BatchingCallSettings.Builder<RowMutation, Void> bulkMutateRowsSettings() {
            return this.bulkMutateRowsSettings;
        }

        public UnaryCallSettings.Builder<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
            return this.checkAndMutateRowSettings;
        }

        public UnaryCallSettings.Builder<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
            return this.readModifyWriteRowSettings;
        }

        public EnhancedBigtableStubSettings build() {
            Preconditions.checkState((this.instanceName != null ? 1 : 0) != 0, (Object)"InstanceName must be set");
            return new EnhancedBigtableStubSettings(this);
        }
    }
}

