/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.common.collect.ImmutableList;
import java.util.List;

class ReadModifyWriteRowCallable
extends UnaryCallable<ReadModifyWriteRow, Row> {
    private final UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> inner;
    private final RequestContext requestContext;

    ReadModifyWriteRowCallable(UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> inner, RequestContext requestContext) {
        this.inner = inner;
        this.requestContext = requestContext;
    }

    public ApiFuture<Row> futureCall(ReadModifyWriteRow request, ApiCallContext context) {
        ApiFuture rawResponse = this.inner.futureCall((Object)request.toProto(this.requestContext), context);
        return ApiFutures.transform((ApiFuture)rawResponse, (ApiFunction)new ApiFunction<ReadModifyWriteRowResponse, Row>(){

            public Row apply(ReadModifyWriteRowResponse readModifyWriteRowResponse) {
                return ReadModifyWriteRowCallable.this.convertResponse(readModifyWriteRowResponse);
            }
        });
    }

    private Row convertResponse(ReadModifyWriteRowResponse response) {
        ImmutableList.Builder cells = ImmutableList.builder();
        for (Family family : response.getRow().getFamiliesList()) {
            for (Column column : family.getColumnsList()) {
                for (Cell cell : column.getCellsList()) {
                    cells.add((Object)RowCell.create(family.getName(), column.getQualifier(), cell.getTimestampMicros(), (List<String>)cell.getLabelsList(), cell.getValue()));
                }
            }
        }
        return Row.create(response.getRow().getKey(), (List<RowCell>)cells.build());
    }
}

