/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsRetryCompletedCallable;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;

@InternalApi
public class ReadRowsResumptionStrategy<RowT>
implements StreamResumptionStrategy<ReadRowsRequest, RowT> {
    private final RowAdapter<RowT> rowAdapter;
    private ByteString lastKey = ByteString.EMPTY;
    private long numProcessed;

    public ReadRowsResumptionStrategy(RowAdapter<RowT> rowAdapter) {
        this.rowAdapter = rowAdapter;
    }

    public boolean canResume() {
        return true;
    }

    public StreamResumptionStrategy<ReadRowsRequest, RowT> createNew() {
        return new ReadRowsResumptionStrategy<RowT>(this.rowAdapter);
    }

    public RowT processResponse(RowT response) {
        this.lastKey = this.rowAdapter.getKey(response);
        if (!this.rowAdapter.isScanMarkerRow(response)) {
            ++this.numProcessed;
        }
        return response;
    }

    public ReadRowsRequest getResumeRequest(ReadRowsRequest request) {
        if (this.lastKey.isEmpty()) {
            return request;
        }
        ReadRowsRequest originalRequest = request;
        if (request.getRows().getRowKeysList().isEmpty() && request.getRows().getRowRangesList().isEmpty()) {
            originalRequest = request.toBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.getDefaultInstance())).build();
        }
        ReadRowsRequest.Builder builder = originalRequest.toBuilder();
        builder.clearRows();
        RowSet.Builder rowSetBuilder = RowSet.newBuilder();
        for (ByteString key : originalRequest.getRows().getRowKeysList()) {
            if (ByteStringComparator.INSTANCE.compare(key, this.lastKey) <= 0) continue;
            rowSetBuilder.addRowKeys(key);
        }
        block11: for (RowRange rowRange : originalRequest.getRows().getRowRangesList()) {
            RowRange.Builder rowRangeBuilder = RowRange.newBuilder();
            switch (rowRange.getEndKeyCase()) {
                case END_KEY_CLOSED: {
                    if (ByteStringComparator.INSTANCE.compare(rowRange.getEndKeyClosed(), this.lastKey) <= 0) continue block11;
                    rowRangeBuilder.setEndKeyClosed(rowRange.getEndKeyClosed());
                    break;
                }
                case END_KEY_OPEN: {
                    if (ByteStringComparator.INSTANCE.compare(rowRange.getEndKeyOpen(), this.lastKey) <= 0) continue block11;
                    rowRangeBuilder.setEndKeyOpen(rowRange.getEndKeyOpen());
                    break;
                }
                case ENDKEY_NOT_SET: {
                    rowRangeBuilder.clearEndKey();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown endKeyCase: " + rowRange.getEndKeyCase());
                }
            }
            switch (rowRange.getStartKeyCase()) {
                case STARTKEY_NOT_SET: {
                    rowRangeBuilder.setStartKeyOpen(this.lastKey);
                    break;
                }
                case START_KEY_OPEN: {
                    if (ByteStringComparator.INSTANCE.compare(rowRange.getStartKeyOpen(), this.lastKey) < 0) {
                        rowRangeBuilder.setStartKeyOpen(this.lastKey);
                        break;
                    }
                    rowRangeBuilder.setStartKeyOpen(rowRange.getStartKeyOpen());
                    break;
                }
                case START_KEY_CLOSED: {
                    if (ByteStringComparator.INSTANCE.compare(rowRange.getStartKeyClosed(), this.lastKey) <= 0) {
                        rowRangeBuilder.setStartKeyOpen(this.lastKey);
                        break;
                    }
                    rowRangeBuilder.setStartKeyClosed(rowRange.getStartKeyClosed());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown startKeyCase: " + rowRange.getStartKeyCase());
                }
            }
            rowSetBuilder.addRowRanges(rowRangeBuilder.build());
        }
        if (rowSetBuilder.getRowRangesCount() == 0 && rowSetBuilder.getRowKeysCount() == 0 || originalRequest.getRowsLimit() > 0L && originalRequest.getRowsLimit() == this.numProcessed) {
            return ReadRowsRetryCompletedCallable.FULFILLED_REQUEST_MARKER;
        }
        if (originalRequest.getRowsLimit() > 0L) {
            Preconditions.checkState((originalRequest.getRowsLimit() > this.numProcessed ? 1 : 0) != 0, (Object)"Detected too many rows for the current row limit during a retry.");
            builder.setRowsLimit(originalRequest.getRowsLimit() - this.numProcessed);
        }
        builder.setRows(rowSetBuilder.build());
        return builder.build();
    }
}

