/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.List;

final class StateMachine<RowT> {
    private final RowAdapter.RowBuilder<RowT> adapter;
    private State currentState;
    private ByteString lastCompleteRowKey;
    private ByteString rowKey;
    private String familyName;
    private ByteString qualifier;
    private long timestamp;
    private List<String> labels;
    private long expectedCellSize;
    private long remainingCellBytes;
    private RowT completeRow;
    private final State AWAITING_NEW_ROW = new State(){

        @Override
        State handleLastScannedRow(ByteString rowKey) {
            StateMachine.this.completeRow = StateMachine.this.adapter.createScanMarkerRow(rowKey);
            StateMachine.this.lastCompleteRowKey = rowKey;
            return AWAITING_ROW_CONSUME;
        }

        @Override
        State handleChunk(ReadRowsResponse.CellChunk chunk) {
            StateMachine.validate(!chunk.getResetRow(), "AWAITING_NEW_ROW: can't reset");
            StateMachine.validate(!chunk.getRowKey().isEmpty(), "AWAITING_NEW_ROW: rowKey missing");
            StateMachine.validate(chunk.hasFamilyName(), "AWAITING_NEW_ROW: family missing");
            StateMachine.validate(chunk.hasQualifier(), "AWAITING_NEW_ROW: qualifier missing");
            if (StateMachine.this.lastCompleteRowKey != null) {
                StateMachine.validate(ByteStringComparator.INSTANCE.compare(StateMachine.this.lastCompleteRowKey, chunk.getRowKey()) < 0, "AWAITING_NEW_ROW: key must be strictly increasing");
            }
            StateMachine.this.rowKey = chunk.getRowKey();
            StateMachine.this.adapter.startRow(StateMachine.this.rowKey);
            return StateMachine.this.AWAITING_NEW_CELL.handleChunk(chunk);
        }
    };
    private final State AWAITING_NEW_CELL = new State(){

        @Override
        State handleChunk(ReadRowsResponse.CellChunk chunk) {
            boolean isSplit;
            if (chunk.getResetRow()) {
                return StateMachine.this.handleResetChunk(chunk);
            }
            if (!chunk.getRowKey().isEmpty()) {
                StateMachine.validate(StateMachine.this.rowKey.equals((Object)chunk.getRowKey()), "AWAITING_NEW_CELL: row keys must not change");
            }
            if (chunk.hasFamilyName()) {
                StateMachine.this.familyName = chunk.getFamilyName().getValue();
                StateMachine.validate(chunk.hasQualifier(), "AWAITING_NEW_CELL: has familyName, but no qualifier");
            }
            if (chunk.hasQualifier()) {
                StateMachine.this.qualifier = chunk.getQualifier().getValue();
            }
            StateMachine.this.timestamp = chunk.getTimestampMicros();
            StateMachine.this.labels = (List)chunk.getLabelsList();
            StateMachine.validate(chunk.getValueSize() >= 0, "AWAITING_NEW_CELL: valueSize can't be negative");
            boolean bl = isSplit = chunk.getValueSize() > 0;
            if (isSplit) {
                StateMachine.validate(!chunk.getCommitRow(), "AWAITING_NEW_CELL: can't commit when valueSize indicates more data");
                StateMachine.validate(!chunk.getValue().isEmpty(), "AWAITING_NEW_CELL: must have data when valueSize promises more data in the next chunk");
                StateMachine.this.expectedCellSize = chunk.getValueSize();
                StateMachine.this.remainingCellBytes = StateMachine.this.expectedCellSize - (long)chunk.getValue().size();
            } else {
                StateMachine.this.expectedCellSize = chunk.getValue().size();
                StateMachine.this.remainingCellBytes = 0L;
            }
            StateMachine.this.adapter.startCell(StateMachine.this.familyName, StateMachine.this.qualifier, StateMachine.this.timestamp, StateMachine.this.labels, StateMachine.this.expectedCellSize);
            StateMachine.this.adapter.cellValue(chunk.getValue());
            if (isSplit) {
                return StateMachine.this.AWAITING_CELL_VALUE;
            }
            StateMachine.this.adapter.finishCell();
            if (!chunk.getCommitRow()) {
                return StateMachine.this.AWAITING_NEW_CELL;
            }
            return StateMachine.this.handleCommit();
        }
    };
    private final State AWAITING_CELL_VALUE = new State(){

        @Override
        State handleChunk(ReadRowsResponse.CellChunk chunk) {
            if (chunk.getResetRow()) {
                return StateMachine.this.handleResetChunk(chunk);
            }
            boolean isLast = chunk.getValueSize() == 0;
            StateMachine.validate(!chunk.hasFamilyName(), "AWAITING_CELL_VALUE: can't have a family");
            StateMachine.validate(!chunk.hasQualifier(), "AWAITING_CELL_VALUE: can't have a qualifier");
            StateMachine.validate(chunk.getTimestampMicros() == 0L, "AWAITING_CELL_VALUE: can't have a timestamp");
            StateMachine.validate(chunk.getLabelsCount() == 0, "AWAITING_CELL_VALUE: can't have labels");
            if (isLast) {
                long missingBytes = StateMachine.this.remainingCellBytes - (long)chunk.getValue().size();
                StateMachine.validate(missingBytes == 0L, "AWAITING_CELL_VALUE: terminal cell is missing " + missingBytes + " bytes");
            } else {
                StateMachine.validate(StateMachine.this.expectedCellSize == (long)chunk.getValueSize(), "AWAITING_CELL_VALUE: valueSizes should be identical for nonterminal chunks");
                StateMachine.validate(!chunk.getCommitRow(), "AWAITING_CELL_VALUE: can't commit with a nonterminal chunk");
            }
            StateMachine.this.remainingCellBytes = StateMachine.this.remainingCellBytes - (long)chunk.getValue().size();
            StateMachine.this.adapter.cellValue(chunk.getValue());
            if (!isLast) {
                return StateMachine.this.AWAITING_CELL_VALUE;
            }
            StateMachine.this.adapter.finishCell();
            if (!chunk.getCommitRow()) {
                return StateMachine.this.AWAITING_NEW_CELL;
            }
            return StateMachine.this.handleCommit();
        }
    };
    private static final State AWAITING_ROW_CONSUME = new State(){

        @Override
        State handleChunk(ReadRowsResponse.CellChunk chunk) {
            throw new IllegalStateException("AWAITING_ROW_CONSUME: Skipping completed row");
        }
    };

    StateMachine(RowAdapter.RowBuilder<RowT> adapter) {
        this.adapter = adapter;
        this.reset();
    }

    void handleLastScannedRow(ByteString key) {
        try {
            this.currentState = this.currentState.handleLastScannedRow(key);
        }
        catch (RuntimeException e) {
            this.currentState = null;
            throw e;
        }
    }

    void handleChunk(ReadRowsResponse.CellChunk chunk) {
        try {
            this.currentState = this.currentState.handleChunk(chunk);
        }
        catch (RuntimeException e) {
            this.currentState = null;
            throw e;
        }
    }

    RowT consumeRow() {
        Preconditions.checkState((this.currentState == AWAITING_ROW_CONSUME ? 1 : 0) != 0, (Object)"No row to consume");
        RowT row = this.completeRow;
        this.reset();
        return row;
    }

    boolean hasCompleteRow() {
        return this.currentState == AWAITING_ROW_CONSUME;
    }

    boolean isRowInProgress() {
        return this.currentState != this.AWAITING_NEW_ROW;
    }

    private void reset() {
        this.currentState = this.AWAITING_NEW_ROW;
        this.rowKey = null;
        this.familyName = null;
        this.qualifier = null;
        this.timestamp = 0L;
        this.labels = null;
        this.expectedCellSize = 0L;
        this.remainingCellBytes = 0L;
        this.completeRow = null;
        this.adapter.reset();
    }

    private State handleResetChunk(ReadRowsResponse.CellChunk cellChunk) {
        StateMachine.validate(cellChunk.getRowKey().isEmpty(), "Reset chunks can't have row keys");
        StateMachine.validate(!cellChunk.hasFamilyName(), "Reset chunks can't have families");
        StateMachine.validate(!cellChunk.hasQualifier(), "Reset chunks can't have qualifiers");
        StateMachine.validate(cellChunk.getTimestampMicros() == 0L, "Reset chunks can't have timestamps");
        StateMachine.validate(cellChunk.getValueSize() == 0, "Reset chunks can't have value sizes");
        StateMachine.validate(cellChunk.getValue().isEmpty(), "Reset chunks can't have values");
        this.reset();
        return this.currentState;
    }

    private State handleCommit() {
        StateMachine.validate(this.remainingCellBytes == 0L, "Can't commit with remaining bytes");
        this.completeRow = this.adapter.finishRow();
        this.lastCompleteRowKey = this.rowKey;
        return AWAITING_ROW_CONSUME;
    }

    private static void validate(boolean condition, String message) {
        if (!condition) {
            throw new InvalidInputException(message);
        }
    }

    static class InvalidInputException
    extends RuntimeException {
        InvalidInputException(String message) {
            super(message);
        }
    }

    static abstract class State {
        State() {
        }

        State handleLastScannedRow(ByteString rowKey) {
            throw new IllegalStateException();
        }

        State handleChunk(ReadRowsResponse.CellChunk chunk) {
            throw new IllegalStateException();
        }
    }
}

