/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.bigtable.admin.v2.InstanceName;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BigtableTableAdminSettings {
    private final String projectId;
    private final String instanceId;
    private final BigtableTableAdminStubSettings stubSettings;

    private BigtableTableAdminSettings(Builder builder) throws IOException {
        this.projectId = (String)Preconditions.checkNotNull((Object)builder.projectId, (Object)"Project id must be set");
        this.instanceId = (String)Preconditions.checkNotNull((Object)builder.instanceId, (Object)"Instance id must be set");
        this.stubSettings = ((BigtableTableAdminStubSettings.Builder)((Object)Verify.verifyNotNull((Object)((Object)builder.stubSettings), (String)"stubSettings should never be null", (Object[])new Object[0]))).build();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    @Deprecated
    @Nonnull
    public InstanceName getInstanceName() {
        return InstanceName.of((String)this.projectId, (String)this.instanceId);
    }

    public BigtableTableAdminStubSettings getStubSettings() {
        return this.stubSettings;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String projectId;
        @Nullable
        private String instanceId;
        private final BigtableTableAdminStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = BigtableTableAdminStubSettings.newBuilder();
        }

        private Builder(BigtableTableAdminSettings settings) {
            this.projectId = settings.projectId;
            this.instanceId = settings.instanceId;
            this.stubSettings = settings.stubSettings.toBuilder();
        }

        public Builder setProjectId(@Nullable String projectId) {
            Preconditions.checkNotNull((Object)projectId);
            this.projectId = projectId;
            return this;
        }

        @Nullable
        public String getProjectId() {
            return this.projectId;
        }

        public Builder setInstanceId(@Nullable String instanceId) {
            Preconditions.checkNotNull((Object)instanceId);
            this.instanceId = instanceId;
            return this;
        }

        @Nullable
        public String getInstanceId() {
            return this.instanceId;
        }

        @Deprecated
        public Builder setInstanceName(@Nonnull InstanceName instanceName) {
            Preconditions.checkNotNull((Object)instanceName);
            this.projectId = instanceName.getProject();
            this.instanceId = instanceName.getInstance();
            return this;
        }

        @Deprecated
        @Nullable
        public InstanceName getInstanceName() {
            if (this.projectId != null && this.instanceId != null) {
                return InstanceName.of((String)this.projectId, (String)this.instanceId);
            }
            return null;
        }

        public BigtableTableAdminStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableTableAdminSettings build() throws IOException {
            return new BigtableTableAdminSettings(this);
        }
    }
}

