/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRule;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Validations;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class ReadModifyWriteRow
implements Serializable {
    private static final long serialVersionUID = -8150045424541029193L;
    private final String tableId;
    private transient ReadModifyWriteRowRequest.Builder builder = ReadModifyWriteRowRequest.newBuilder();

    private ReadModifyWriteRow(@Nonnull String tableId, @Nonnull ByteString key) {
        Preconditions.checkNotNull((Object)tableId, (Object)"tableId can't be null.");
        Preconditions.checkNotNull((Object)key, (Object)"key can't be null.");
        this.tableId = tableId;
        this.builder.setRowKey(key);
    }

    public static ReadModifyWriteRow create(@Nonnull String tableId, @Nonnull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key can't be null.");
        return new ReadModifyWriteRow(tableId, ByteString.copyFromUtf8((String)key));
    }

    public static ReadModifyWriteRow create(@Nonnull String tableId, @Nonnull ByteString key) {
        return new ReadModifyWriteRow(tableId, key);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (ReadModifyWriteRowRequest.Builder)ReadModifyWriteRowRequest.newBuilder().mergeFrom((InputStream)input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo((OutputStream)output);
    }

    public ReadModifyWriteRow append(@Nonnull String familyName, @Nonnull String qualifier, @Nonnull String value) {
        return this.append(familyName, ByteString.copyFromUtf8((String)qualifier), ByteString.copyFromUtf8((String)value));
    }

    public ReadModifyWriteRow append(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull ByteString value) {
        Validations.validateFamily(familyName);
        Preconditions.checkNotNull((Object)qualifier, (Object)"Qualifier can't be null");
        Preconditions.checkNotNull((Object)value, (Object)"Value can't be null");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"Value can't be empty");
        ReadModifyWriteRule rule = ReadModifyWriteRule.newBuilder().setFamilyName(familyName).setColumnQualifier(qualifier).setAppendValue(value).build();
        this.builder.addRules(rule);
        return this;
    }

    public ReadModifyWriteRow increment(@Nonnull String familyName, @Nonnull String qualifier, long amount) {
        return this.increment(familyName, ByteString.copyFromUtf8((String)qualifier), amount);
    }

    public ReadModifyWriteRow increment(@Nonnull String familyName, @Nonnull ByteString qualifier, long amount) {
        Validations.validateFamily(familyName);
        Preconditions.checkNotNull((Object)qualifier, (Object)"Qualifier can't be null");
        ReadModifyWriteRule rule = ReadModifyWriteRule.newBuilder().setFamilyName(familyName).setColumnQualifier(qualifier).setIncrementAmount(amount).build();
        this.builder.addRules(rule);
        return this;
    }

    @InternalApi
    public ReadModifyWriteRowRequest toProto(RequestContext requestContext) {
        String tableName = NameUtil.formatTableName(requestContext.getProjectId(), requestContext.getInstanceId(), this.tableId);
        return this.builder.setTableName(tableName).setAppProfileId(requestContext.getAppProfileId()).build();
    }
}

