/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.stub.AwaitReplicationCallable;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.cloud.bigtable.admin.v2.stub.GrpcBigtableTableAdminStub;
import java.io.IOException;
import org.threeten.bp.Duration;

@InternalApi
public class EnhancedBigtableTableAdminStub
extends GrpcBigtableTableAdminStub {
    private final BigtableTableAdminStubSettings settings;
    private final ClientContext clientContext;
    private final AwaitReplicationCallable awaitReplicationCallable;

    public static EnhancedBigtableTableAdminStub createEnhanced(BigtableTableAdminStubSettings settings) throws IOException {
        return new EnhancedBigtableTableAdminStub(settings, ClientContext.create((StubSettings)settings));
    }

    private EnhancedBigtableTableAdminStub(BigtableTableAdminStubSettings settings, ClientContext clientContext) throws IOException {
        super(settings, clientContext);
        this.settings = settings;
        this.clientContext = clientContext;
        this.awaitReplicationCallable = this.createAwaitReplicationCallable();
    }

    private AwaitReplicationCallable createAwaitReplicationCallable() {
        RetrySettings pollingSettings = RetrySettings.newBuilder().setTotalTimeout(this.settings.checkConsistencySettings().getRetrySettings().getTotalTimeout()).setInitialRetryDelay(Duration.ofSeconds((long)10L)).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ofSeconds((long)10L)).setJittered(true).setInitialRpcTimeout(Duration.ZERO).setMaxRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).build();
        return AwaitReplicationCallable.create(this.generateConsistencyTokenCallable(), this.checkConsistencyCallable(), this.clientContext, pollingSettings);
    }

    public UnaryCallable<TableName, Void> awaitReplicationCallable() {
        return this.awaitReplicationCallable;
    }
}

