/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import io.grpc.ManagedChannelBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public final class BigtableDataSettings {
    private final EnhancedBigtableStubSettings stubSettings;

    private BigtableDataSettings(Builder builder) {
        this.stubSettings = builder.stubSettings().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderForEmulator(int port) {
        Builder builder = BigtableDataSettings.newBuilder();
        ((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)builder.stubSettings().setProjectId("fake-project").setInstanceId("fake-instance").setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setEndpoint("localhost:" + port)).setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(0x10000000)).setPoolSize(1).setChannelConfigurator((ApiFunction)new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            public ManagedChannelBuilder apply(ManagedChannelBuilder input) {
                return input.usePlaintext();
            }
        }).build());
        return builder;
    }

    public String getProjectId() {
        return this.stubSettings.getProjectId();
    }

    public String getInstanceId() {
        return this.stubSettings.getInstanceId();
    }

    public String getAppProfileId() {
        return this.stubSettings.getAppProfileId();
    }

    public EnhancedBigtableStubSettings getStubSettings() {
        return this.stubSettings;
    }

    @Deprecated
    public ServerStreamingCallSettings<Query, Row> readRowsSettings() {
        return this.stubSettings.readRowsSettings();
    }

    public UnaryCallSettings<Query, Row> readRowSettings() {
        return this.stubSettings.readRowSettings();
    }

    @Deprecated
    public UnaryCallSettings<String, List<KeyOffset>> sampleRowKeysSettings() {
        return this.stubSettings.sampleRowKeysSettings();
    }

    @Deprecated
    public UnaryCallSettings<RowMutation, Void> mutateRowSettings() {
        return this.stubSettings.mutateRowSettings();
    }

    @Deprecated
    public BatchingCallSettings<RowMutation, Void> bulkMutationsSettings() {
        return this.stubSettings.bulkMutateRowsSettings();
    }

    @Deprecated
    public UnaryCallSettings<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
        return this.stubSettings.checkAndMutateRowSettings();
    }

    @Deprecated
    public UnaryCallSettings<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
        return this.stubSettings.readModifyWriteRowSettings();
    }

    @Deprecated
    public ExecutorProvider getExecutorProvider() {
        return this.stubSettings.getExecutorProvider();
    }

    @Deprecated
    public TransportChannelProvider getTransportChannelProvider() {
        return this.stubSettings.getTransportChannelProvider();
    }

    @Deprecated
    public CredentialsProvider getCredentialsProvider() {
        return this.stubSettings.getCredentialsProvider();
    }

    @Deprecated
    public HeaderProvider getHeaderProvider() {
        return this.stubSettings.getHeaderProvider();
    }

    @Deprecated
    public ApiClock getClock() {
        return this.stubSettings.getClock();
    }

    @Deprecated
    public String getEndpoint() {
        return this.stubSettings.getEndpoint();
    }

    @Deprecated
    @Nullable
    public WatchdogProvider getStreamWatchdogProvider() {
        return this.stubSettings.getStreamWatchdogProvider();
    }

    @Deprecated
    @Nonnull
    public Duration getStreamWatchdogCheckInterval() {
        return this.stubSettings.getStreamWatchdogCheckInterval();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private final EnhancedBigtableStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = EnhancedBigtableStubSettings.newBuilder();
        }

        private Builder(BigtableDataSettings settings) {
            this.stubSettings = settings.getStubSettings().toBuilder();
        }

        public Builder setProjectId(@Nonnull String projectId) {
            this.stubSettings.setProjectId(projectId);
            return this;
        }

        public String getProjectId() {
            return this.stubSettings.getProjectId();
        }

        public Builder setInstanceId(@Nonnull String instanceId) {
            this.stubSettings.setInstanceId(instanceId);
            return this;
        }

        public String getInstanceId() {
            return this.stubSettings.getInstanceId();
        }

        public Builder setAppProfileId(@Nonnull String appProfileId) {
            this.stubSettings.setAppProfileId(appProfileId);
            return this;
        }

        public String getAppProfileId() {
            return this.stubSettings.getAppProfileId();
        }

        @Deprecated
        public ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings() {
            return this.stubSettings.readRowsSettings();
        }

        @Deprecated
        public UnaryCallSettings.Builder<Query, Row> readRowSettings() {
            return this.stubSettings.readRowSettings();
        }

        @Deprecated
        public UnaryCallSettings.Builder<String, List<KeyOffset>> sampleRowKeysSettings() {
            return this.stubSettings.sampleRowKeysSettings();
        }

        @Deprecated
        public UnaryCallSettings.Builder<RowMutation, Void> mutateRowSettings() {
            return this.stubSettings.mutateRowSettings();
        }

        @Deprecated
        public BatchingCallSettings.Builder<RowMutation, Void> bulkMutationsSettings() {
            return this.stubSettings.bulkMutateRowsSettings();
        }

        @Deprecated
        public UnaryCallSettings.Builder<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
            return this.stubSettings.checkAndMutateRowSettings();
        }

        @Deprecated
        public UnaryCallSettings.Builder<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
            return this.stubSettings.readModifyWriteRowSettings();
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.stubSettings.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.stubSettings.getCredentialsProvider();
        }

        public EnhancedBigtableStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableDataSettings build() {
            return new BigtableDataSettings(this);
        }

        @Deprecated
        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.stubSettings.setExecutorProvider(executorProvider);
            return this;
        }

        @Deprecated
        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.stubSettings.setHeaderProvider(headerProvider);
            return this;
        }

        @Deprecated
        public Builder setTransportChannelProvider(TransportChannelProvider transportChannelProvider) {
            this.stubSettings.setTransportChannelProvider(transportChannelProvider);
            return this;
        }

        @Deprecated
        public Builder setStreamWatchdogProvider(@Nullable WatchdogProvider streamWatchdogProvider) {
            this.stubSettings.setStreamWatchdogProvider(streamWatchdogProvider);
            return this;
        }

        @Deprecated
        public Builder setClock(ApiClock clock) {
            this.stubSettings.setClock(clock);
            return this;
        }

        @Deprecated
        public Builder setEndpoint(String endpoint) {
            this.stubSettings.setEndpoint(endpoint);
            return this;
        }

        @Deprecated
        public Builder setStreamWatchdogCheckInterval(@Nonnull Duration checkInterval) {
            this.stubSettings.setStreamWatchdogCheckInterval(checkInterval);
            return this;
        }

        @Deprecated
        public ExecutorProvider getExecutorProvider() {
            return this.stubSettings.getExecutorProvider();
        }

        @Deprecated
        public TransportChannelProvider getTransportChannelProvider() {
            return this.stubSettings.getTransportChannelProvider();
        }

        @Deprecated
        public HeaderProvider getHeaderProvider() {
            return this.stubSettings.getHeaderProvider();
        }

        @Deprecated
        @Nullable
        public WatchdogProvider getStreamWatchdogProvider() {
            return this.stubSettings.getStreamWatchdogProvider();
        }

        @Deprecated
        public ApiClock getClock() {
            return this.stubSettings.getClock();
        }

        @Deprecated
        public String getEndpoint() {
            return this.stubSettings.getEndpoint();
        }

        @Deprecated
        @Nonnull
        public Duration getStreamWatchdogCheckInterval() {
            return this.stubSettings.getStreamWatchdogCheckInterval();
        }
    }
}

