/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteInterconnectHttpRequest;
import com.google.cloud.compute.v1.GetDiagnosticsInterconnectHttpRequest;
import com.google.cloud.compute.v1.GetInterconnectHttpRequest;
import com.google.cloud.compute.v1.InsertInterconnectHttpRequest;
import com.google.cloud.compute.v1.Interconnect;
import com.google.cloud.compute.v1.InterconnectList;
import com.google.cloud.compute.v1.InterconnectSettings;
import com.google.cloud.compute.v1.InterconnectsGetDiagnosticsResponse;
import com.google.cloud.compute.v1.ListInterconnectsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalInterconnectName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.stub.InterconnectStub;
import com.google.cloud.compute.v1.stub.InterconnectStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class InterconnectClient
implements BackgroundResource {
    private final InterconnectSettings settings;
    private final InterconnectStub stub;

    public static final InterconnectClient create() throws IOException {
        return InterconnectClient.create(InterconnectSettings.newBuilder().build());
    }

    public static final InterconnectClient create(InterconnectSettings settings) throws IOException {
        return new InterconnectClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InterconnectClient create(InterconnectStub stub) {
        return new InterconnectClient(stub);
    }

    protected InterconnectClient(InterconnectSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InterconnectStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InterconnectClient(InterconnectStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InterconnectSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InterconnectStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteInterconnect(ProjectGlobalInterconnectName interconnect) {
        DeleteInterconnectHttpRequest request = DeleteInterconnectHttpRequest.newBuilder().setInterconnect(interconnect == null ? null : interconnect.toString()).build();
        return this.deleteInterconnect(request);
    }

    @BetaApi
    public final Operation deleteInterconnect(String interconnect) {
        DeleteInterconnectHttpRequest request = DeleteInterconnectHttpRequest.newBuilder().setInterconnect(interconnect).build();
        return this.deleteInterconnect(request);
    }

    @BetaApi
    public final Operation deleteInterconnect(DeleteInterconnectHttpRequest request) {
        return (Operation)this.deleteInterconnectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteInterconnectHttpRequest, Operation> deleteInterconnectCallable() {
        return this.stub.deleteInterconnectCallable();
    }

    @BetaApi
    public final Interconnect getInterconnect(ProjectGlobalInterconnectName interconnect) {
        GetInterconnectHttpRequest request = GetInterconnectHttpRequest.newBuilder().setInterconnect(interconnect == null ? null : interconnect.toString()).build();
        return this.getInterconnect(request);
    }

    @BetaApi
    public final Interconnect getInterconnect(String interconnect) {
        GetInterconnectHttpRequest request = GetInterconnectHttpRequest.newBuilder().setInterconnect(interconnect).build();
        return this.getInterconnect(request);
    }

    @BetaApi
    public final Interconnect getInterconnect(GetInterconnectHttpRequest request) {
        return (Interconnect)this.getInterconnectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetInterconnectHttpRequest, Interconnect> getInterconnectCallable() {
        return this.stub.getInterconnectCallable();
    }

    @BetaApi
    public final InterconnectsGetDiagnosticsResponse getDiagnosticsInterconnect(ProjectGlobalInterconnectName interconnect) {
        GetDiagnosticsInterconnectHttpRequest request = GetDiagnosticsInterconnectHttpRequest.newBuilder().setInterconnect(interconnect == null ? null : interconnect.toString()).build();
        return this.getDiagnosticsInterconnect(request);
    }

    @BetaApi
    public final InterconnectsGetDiagnosticsResponse getDiagnosticsInterconnect(String interconnect) {
        GetDiagnosticsInterconnectHttpRequest request = GetDiagnosticsInterconnectHttpRequest.newBuilder().setInterconnect(interconnect).build();
        return this.getDiagnosticsInterconnect(request);
    }

    @BetaApi
    public final InterconnectsGetDiagnosticsResponse getDiagnosticsInterconnect(GetDiagnosticsInterconnectHttpRequest request) {
        return (InterconnectsGetDiagnosticsResponse)this.getDiagnosticsInterconnectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetDiagnosticsInterconnectHttpRequest, InterconnectsGetDiagnosticsResponse> getDiagnosticsInterconnectCallable() {
        return this.stub.getDiagnosticsInterconnectCallable();
    }

    @BetaApi
    public final Operation insertInterconnect(ProjectName project, Interconnect interconnectResource) {
        InsertInterconnectHttpRequest request = InsertInterconnectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setInterconnectResource(interconnectResource).build();
        return this.insertInterconnect(request);
    }

    @BetaApi
    public final Operation insertInterconnect(String project, Interconnect interconnectResource) {
        InsertInterconnectHttpRequest request = InsertInterconnectHttpRequest.newBuilder().setProject(project).setInterconnectResource(interconnectResource).build();
        return this.insertInterconnect(request);
    }

    @BetaApi
    public final Operation insertInterconnect(InsertInterconnectHttpRequest request) {
        return (Operation)this.insertInterconnectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertInterconnectHttpRequest, Operation> insertInterconnectCallable() {
        return this.stub.insertInterconnectCallable();
    }

    @BetaApi
    public final ListInterconnectsPagedResponse listInterconnects(ProjectName project) {
        ListInterconnectsHttpRequest request = ListInterconnectsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listInterconnects(request);
    }

    @BetaApi
    public final ListInterconnectsPagedResponse listInterconnects(String project) {
        ListInterconnectsHttpRequest request = ListInterconnectsHttpRequest.newBuilder().setProject(project).build();
        return this.listInterconnects(request);
    }

    @BetaApi
    public final ListInterconnectsPagedResponse listInterconnects(ListInterconnectsHttpRequest request) {
        return (ListInterconnectsPagedResponse)((Object)this.listInterconnectsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListInterconnectsHttpRequest, ListInterconnectsPagedResponse> listInterconnectsPagedCallable() {
        return this.stub.listInterconnectsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListInterconnectsHttpRequest, InterconnectList> listInterconnectsCallable() {
        return this.stub.listInterconnectsCallable();
    }

    @BetaApi
    public final Operation patchInterconnect(ProjectGlobalInterconnectName interconnect, Interconnect interconnectResource, List<String> fieldMask) {
        PatchInterconnectHttpRequest request = PatchInterconnectHttpRequest.newBuilder().setInterconnect(interconnect == null ? null : interconnect.toString()).setInterconnectResource(interconnectResource).addAllFieldMask(fieldMask).build();
        return this.patchInterconnect(request);
    }

    @BetaApi
    public final Operation patchInterconnect(String interconnect, Interconnect interconnectResource, List<String> fieldMask) {
        PatchInterconnectHttpRequest request = PatchInterconnectHttpRequest.newBuilder().setInterconnect(interconnect).setInterconnectResource(interconnectResource).addAllFieldMask(fieldMask).build();
        return this.patchInterconnect(request);
    }

    @BetaApi
    public final Operation patchInterconnect(PatchInterconnectHttpRequest request) {
        return (Operation)this.patchInterconnectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchInterconnectHttpRequest, Operation> patchInterconnectCallable() {
        return this.stub.patchInterconnectCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInterconnectsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectsHttpRequest, InterconnectList, Interconnect, ListInterconnectsPage, ListInterconnectsFixedSizeCollection> {
        private ListInterconnectsFixedSizeCollection(List<ListInterconnectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInterconnectsFixedSizeCollection createEmptyCollection() {
            return new ListInterconnectsFixedSizeCollection(null, 0);
        }

        protected ListInterconnectsFixedSizeCollection createCollection(List<ListInterconnectsPage> pages, int collectionSize) {
            return new ListInterconnectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInterconnectsPage
    extends AbstractPage<ListInterconnectsHttpRequest, InterconnectList, Interconnect, ListInterconnectsPage> {
        private ListInterconnectsPage(PageContext<ListInterconnectsHttpRequest, InterconnectList, Interconnect> context, InterconnectList response) {
            super(context, (Object)response);
        }

        private static ListInterconnectsPage createEmptyPage() {
            return new ListInterconnectsPage(null, null);
        }

        protected ListInterconnectsPage createPage(PageContext<ListInterconnectsHttpRequest, InterconnectList, Interconnect> context, InterconnectList response) {
            return new ListInterconnectsPage(context, response);
        }

        public ApiFuture<ListInterconnectsPage> createPageAsync(PageContext<ListInterconnectsHttpRequest, InterconnectList, Interconnect> context, ApiFuture<InterconnectList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInterconnectsPagedResponse
    extends AbstractPagedListResponse<ListInterconnectsHttpRequest, InterconnectList, Interconnect, ListInterconnectsPage, ListInterconnectsFixedSizeCollection> {
        public static ApiFuture<ListInterconnectsPagedResponse> createAsync(PageContext<ListInterconnectsHttpRequest, InterconnectList, Interconnect> context, ApiFuture<InterconnectList> futureResponse) {
            ApiFuture<ListInterconnectsPage> futurePage = ListInterconnectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInterconnectsPage, ListInterconnectsPagedResponse>(){

                public ListInterconnectsPagedResponse apply(ListInterconnectsPage input) {
                    return new ListInterconnectsPagedResponse(input);
                }
            });
        }

        private ListInterconnectsPagedResponse(ListInterconnectsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInterconnectsFixedSizeCollection.createEmptyCollection());
        }
    }
}

