/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.InterconnectDiagnosticsARPEntry;
import com.google.cloud.compute.v1.InterconnectDiagnosticsLinkLACPStatus;
import com.google.cloud.compute.v1.InterconnectDiagnosticsLinkOpticalPower;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InterconnectDiagnosticsLinkStatus
implements ApiMessage {
    private final List<InterconnectDiagnosticsARPEntry> arpCaches;
    private final String circuitId;
    private final String googleDemarc;
    private final InterconnectDiagnosticsLinkLACPStatus lacpStatus;
    private final InterconnectDiagnosticsLinkOpticalPower receivingOpticalPower;
    private final InterconnectDiagnosticsLinkOpticalPower transmittingOpticalPower;
    private static final InterconnectDiagnosticsLinkStatus DEFAULT_INSTANCE = new InterconnectDiagnosticsLinkStatus();

    private InterconnectDiagnosticsLinkStatus() {
        this.arpCaches = null;
        this.circuitId = null;
        this.googleDemarc = null;
        this.lacpStatus = null;
        this.receivingOpticalPower = null;
        this.transmittingOpticalPower = null;
    }

    private InterconnectDiagnosticsLinkStatus(List<InterconnectDiagnosticsARPEntry> arpCaches, String circuitId, String googleDemarc, InterconnectDiagnosticsLinkLACPStatus lacpStatus, InterconnectDiagnosticsLinkOpticalPower receivingOpticalPower, InterconnectDiagnosticsLinkOpticalPower transmittingOpticalPower) {
        this.arpCaches = arpCaches;
        this.circuitId = circuitId;
        this.googleDemarc = googleDemarc;
        this.lacpStatus = lacpStatus;
        this.receivingOpticalPower = receivingOpticalPower;
        this.transmittingOpticalPower = transmittingOpticalPower;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("arpCaches")) {
            return this.arpCaches;
        }
        if (fieldName.equals("circuitId")) {
            return this.circuitId;
        }
        if (fieldName.equals("googleDemarc")) {
            return this.googleDemarc;
        }
        if (fieldName.equals("lacpStatus")) {
            return this.lacpStatus;
        }
        if (fieldName.equals("receivingOpticalPower")) {
            return this.receivingOpticalPower;
        }
        if (fieldName.equals("transmittingOpticalPower")) {
            return this.transmittingOpticalPower;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<InterconnectDiagnosticsARPEntry> getArpCachesList() {
        return this.arpCaches;
    }

    public String getCircuitId() {
        return this.circuitId;
    }

    public String getGoogleDemarc() {
        return this.googleDemarc;
    }

    public InterconnectDiagnosticsLinkLACPStatus getLacpStatus() {
        return this.lacpStatus;
    }

    public InterconnectDiagnosticsLinkOpticalPower getReceivingOpticalPower() {
        return this.receivingOpticalPower;
    }

    public InterconnectDiagnosticsLinkOpticalPower getTransmittingOpticalPower() {
        return this.transmittingOpticalPower;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InterconnectDiagnosticsLinkStatus prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InterconnectDiagnosticsLinkStatus getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InterconnectDiagnosticsLinkStatus{arpCaches=" + this.arpCaches + ", circuitId=" + this.circuitId + ", googleDemarc=" + this.googleDemarc + ", lacpStatus=" + this.lacpStatus + ", receivingOpticalPower=" + this.receivingOpticalPower + ", transmittingOpticalPower=" + this.transmittingOpticalPower + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InterconnectDiagnosticsLinkStatus) {
            InterconnectDiagnosticsLinkStatus that = (InterconnectDiagnosticsLinkStatus)o;
            return Objects.equals(this.arpCaches, that.getArpCachesList()) && Objects.equals(this.circuitId, that.getCircuitId()) && Objects.equals(this.googleDemarc, that.getGoogleDemarc()) && Objects.equals(this.lacpStatus, that.getLacpStatus()) && Objects.equals(this.receivingOpticalPower, that.getReceivingOpticalPower()) && Objects.equals(this.transmittingOpticalPower, that.getTransmittingOpticalPower());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.arpCaches, this.circuitId, this.googleDemarc, this.lacpStatus, this.receivingOpticalPower, this.transmittingOpticalPower);
    }

    public static class Builder {
        private List<InterconnectDiagnosticsARPEntry> arpCaches;
        private String circuitId;
        private String googleDemarc;
        private InterconnectDiagnosticsLinkLACPStatus lacpStatus;
        private InterconnectDiagnosticsLinkOpticalPower receivingOpticalPower;
        private InterconnectDiagnosticsLinkOpticalPower transmittingOpticalPower;

        Builder() {
        }

        public Builder mergeFrom(InterconnectDiagnosticsLinkStatus other) {
            if (other == InterconnectDiagnosticsLinkStatus.getDefaultInstance()) {
                return this;
            }
            if (other.getArpCachesList() != null) {
                this.arpCaches = other.arpCaches;
            }
            if (other.getCircuitId() != null) {
                this.circuitId = other.circuitId;
            }
            if (other.getGoogleDemarc() != null) {
                this.googleDemarc = other.googleDemarc;
            }
            if (other.getLacpStatus() != null) {
                this.lacpStatus = other.lacpStatus;
            }
            if (other.getReceivingOpticalPower() != null) {
                this.receivingOpticalPower = other.receivingOpticalPower;
            }
            if (other.getTransmittingOpticalPower() != null) {
                this.transmittingOpticalPower = other.transmittingOpticalPower;
            }
            return this;
        }

        Builder(InterconnectDiagnosticsLinkStatus source) {
            this.arpCaches = source.arpCaches;
            this.circuitId = source.circuitId;
            this.googleDemarc = source.googleDemarc;
            this.lacpStatus = source.lacpStatus;
            this.receivingOpticalPower = source.receivingOpticalPower;
            this.transmittingOpticalPower = source.transmittingOpticalPower;
        }

        public List<InterconnectDiagnosticsARPEntry> getArpCachesList() {
            return this.arpCaches;
        }

        public Builder addAllArpCaches(List<InterconnectDiagnosticsARPEntry> arpCaches) {
            if (this.arpCaches == null) {
                this.arpCaches = new LinkedList<InterconnectDiagnosticsARPEntry>();
            }
            this.arpCaches.addAll(arpCaches);
            return this;
        }

        public Builder addArpCaches(InterconnectDiagnosticsARPEntry arpCaches) {
            if (this.arpCaches == null) {
                this.arpCaches = new LinkedList<InterconnectDiagnosticsARPEntry>();
            }
            this.arpCaches.add(arpCaches);
            return this;
        }

        public String getCircuitId() {
            return this.circuitId;
        }

        public Builder setCircuitId(String circuitId) {
            this.circuitId = circuitId;
            return this;
        }

        public String getGoogleDemarc() {
            return this.googleDemarc;
        }

        public Builder setGoogleDemarc(String googleDemarc) {
            this.googleDemarc = googleDemarc;
            return this;
        }

        public InterconnectDiagnosticsLinkLACPStatus getLacpStatus() {
            return this.lacpStatus;
        }

        public Builder setLacpStatus(InterconnectDiagnosticsLinkLACPStatus lacpStatus) {
            this.lacpStatus = lacpStatus;
            return this;
        }

        public InterconnectDiagnosticsLinkOpticalPower getReceivingOpticalPower() {
            return this.receivingOpticalPower;
        }

        public Builder setReceivingOpticalPower(InterconnectDiagnosticsLinkOpticalPower receivingOpticalPower) {
            this.receivingOpticalPower = receivingOpticalPower;
            return this;
        }

        public InterconnectDiagnosticsLinkOpticalPower getTransmittingOpticalPower() {
            return this.transmittingOpticalPower;
        }

        public Builder setTransmittingOpticalPower(InterconnectDiagnosticsLinkOpticalPower transmittingOpticalPower) {
            this.transmittingOpticalPower = transmittingOpticalPower;
            return this;
        }

        public InterconnectDiagnosticsLinkStatus build() {
            return new InterconnectDiagnosticsLinkStatus(this.arpCaches, this.circuitId, this.googleDemarc, this.lacpStatus, this.receivingOpticalPower, this.transmittingOpticalPower);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllArpCaches(this.arpCaches);
            newBuilder.setCircuitId(this.circuitId);
            newBuilder.setGoogleDemarc(this.googleDemarc);
            newBuilder.setLacpStatus(this.lacpStatus);
            newBuilder.setReceivingOpticalPower(this.receivingOpticalPower);
            newBuilder.setTransmittingOpticalPower(this.transmittingOpticalPower);
            return newBuilder;
        }
    }
}

