/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetLicenseCodeHttpRequest;
import com.google.cloud.compute.v1.LicenseCode;
import com.google.cloud.compute.v1.LicenseCodeSettings;
import com.google.cloud.compute.v1.ProjectGlobalLicenseCodeName;
import com.google.cloud.compute.v1.ProjectGlobalLicenseCodeResourceName;
import com.google.cloud.compute.v1.TestIamPermissionsLicenseCodeHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.LicenseCodeStub;
import com.google.cloud.compute.v1.stub.LicenseCodeStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class LicenseCodeClient
implements BackgroundResource {
    private final LicenseCodeSettings settings;
    private final LicenseCodeStub stub;

    public static final LicenseCodeClient create() throws IOException {
        return LicenseCodeClient.create(LicenseCodeSettings.newBuilder().build());
    }

    public static final LicenseCodeClient create(LicenseCodeSettings settings) throws IOException {
        return new LicenseCodeClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final LicenseCodeClient create(LicenseCodeStub stub) {
        return new LicenseCodeClient(stub);
    }

    protected LicenseCodeClient(LicenseCodeSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LicenseCodeStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected LicenseCodeClient(LicenseCodeStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LicenseCodeSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LicenseCodeStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final LicenseCode getLicenseCode(ProjectGlobalLicenseCodeName licenseCode) {
        GetLicenseCodeHttpRequest request = GetLicenseCodeHttpRequest.newBuilder().setLicenseCode(licenseCode == null ? null : licenseCode.toString()).build();
        return this.getLicenseCode(request);
    }

    @BetaApi
    public final LicenseCode getLicenseCode(String licenseCode) {
        GetLicenseCodeHttpRequest request = GetLicenseCodeHttpRequest.newBuilder().setLicenseCode(licenseCode).build();
        return this.getLicenseCode(request);
    }

    @BetaApi
    public final LicenseCode getLicenseCode(GetLicenseCodeHttpRequest request) {
        return (LicenseCode)this.getLicenseCodeCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetLicenseCodeHttpRequest, LicenseCode> getLicenseCodeCallable() {
        return this.stub.getLicenseCodeCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsLicenseCode(ProjectGlobalLicenseCodeResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsLicenseCodeHttpRequest request = TestIamPermissionsLicenseCodeHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsLicenseCode(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsLicenseCode(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsLicenseCodeHttpRequest request = TestIamPermissionsLicenseCodeHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsLicenseCode(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsLicenseCode(TestIamPermissionsLicenseCodeHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsLicenseCodeCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsLicenseCodeHttpRequest, TestPermissionsResponse> testIamPermissionsLicenseCodeCallable() {
        return this.stub.testIamPermissionsLicenseCodeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

