/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalHealthCheckName
implements ResourceName {
    private final String healthCheck;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/healthChecks/{healthCheck}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalHealthCheckName(Builder builder) {
        this.healthCheck = (String)Preconditions.checkNotNull((Object)builder.getHealthCheck());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalHealthCheckName of(String healthCheck, String project) {
        return ProjectGlobalHealthCheckName.newBuilder().setHealthCheck(healthCheck).setProject(project).build();
    }

    public static String format(String healthCheck, String project) {
        return ProjectGlobalHealthCheckName.of(healthCheck, project).toString();
    }

    public String getHealthCheck() {
        return this.healthCheck;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalHealthCheckName projectGlobalHealthCheckName = this;
            synchronized (projectGlobalHealthCheckName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"healthCheck", (Object)this.healthCheck);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalHealthCheckName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalHealthCheckName>(){

            public ProjectGlobalHealthCheckName parse(String formattedString) {
                return ProjectGlobalHealthCheckName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalHealthCheckName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalHealthCheckName.parse: formattedString not in valid format");
        return ProjectGlobalHealthCheckName.of((String)matchMap.get("healthCheck"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"healthCheck", this.healthCheck, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalHealthCheckName) {
            ProjectGlobalHealthCheckName that = (ProjectGlobalHealthCheckName)o;
            return Objects.equals(this.healthCheck, that.getHealthCheck()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.healthCheck, this.project);
    }

    public static class Builder {
        private String healthCheck;
        private String project;

        public String getHealthCheck() {
            return this.healthCheck;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setHealthCheck(String healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalHealthCheckName projectGlobalHealthCheckName) {
            this.healthCheck = projectGlobalHealthCheckName.healthCheck;
            this.project = projectGlobalHealthCheckName.project;
        }

        public ProjectGlobalHealthCheckName build() {
            return new ProjectGlobalHealthCheckName(this);
        }
    }
}

