/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionCommitmentName
implements ResourceName {
    private final String commitment;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/commitments/{commitment}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionCommitmentName(Builder builder) {
        this.commitment = (String)Preconditions.checkNotNull((Object)builder.getCommitment());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionCommitmentName of(String commitment, String project, String region) {
        return ProjectRegionCommitmentName.newBuilder().setCommitment(commitment).setProject(project).setRegion(region).build();
    }

    public static String format(String commitment, String project, String region) {
        return ProjectRegionCommitmentName.of(commitment, project, region).toString();
    }

    public String getCommitment() {
        return this.commitment;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionCommitmentName projectRegionCommitmentName = this;
            synchronized (projectRegionCommitmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"commitment", (Object)this.commitment);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionCommitmentName> newFactory() {
        return new ResourceNameFactory<ProjectRegionCommitmentName>(){

            public ProjectRegionCommitmentName parse(String formattedString) {
                return ProjectRegionCommitmentName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionCommitmentName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionCommitmentName.parse: formattedString not in valid format");
        return ProjectRegionCommitmentName.of((String)matchMap.get("commitment"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"commitment", this.commitment, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionCommitmentName) {
            ProjectRegionCommitmentName that = (ProjectRegionCommitmentName)o;
            return Objects.equals(this.commitment, that.getCommitment()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.commitment, this.project, this.region);
    }

    public static class Builder {
        private String commitment;
        private String project;
        private String region;

        public String getCommitment() {
            return this.commitment;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setCommitment(String commitment) {
            this.commitment = commitment;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionCommitmentName projectRegionCommitmentName) {
            this.commitment = projectRegionCommitmentName.commitment;
            this.project = projectRegionCommitmentName.project;
            this.region = projectRegionCommitmentName.region;
        }

        public ProjectRegionCommitmentName build() {
            return new ProjectRegionCommitmentName(this);
        }
    }
}

