/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionVpnTunnelName
implements ResourceName {
    private final String project;
    private final String region;
    private final String vpnTunnel;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/vpnTunnels/{vpnTunnel}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionVpnTunnelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.vpnTunnel = (String)Preconditions.checkNotNull((Object)builder.getVpnTunnel());
    }

    public static ProjectRegionVpnTunnelName of(String project, String region, String vpnTunnel) {
        return ProjectRegionVpnTunnelName.newBuilder().setProject(project).setRegion(region).setVpnTunnel(vpnTunnel).build();
    }

    public static String format(String project, String region, String vpnTunnel) {
        return ProjectRegionVpnTunnelName.of(project, region, vpnTunnel).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getVpnTunnel() {
        return this.vpnTunnel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionVpnTunnelName projectRegionVpnTunnelName = this;
            synchronized (projectRegionVpnTunnelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"vpnTunnel", (Object)this.vpnTunnel);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionVpnTunnelName> newFactory() {
        return new ResourceNameFactory<ProjectRegionVpnTunnelName>(){

            public ProjectRegionVpnTunnelName parse(String formattedString) {
                return ProjectRegionVpnTunnelName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionVpnTunnelName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionVpnTunnelName.parse: formattedString not in valid format");
        return ProjectRegionVpnTunnelName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("vpnTunnel"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "vpnTunnel", this.vpnTunnel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionVpnTunnelName) {
            ProjectRegionVpnTunnelName that = (ProjectRegionVpnTunnelName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.vpnTunnel, that.getVpnTunnel());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.vpnTunnel);
    }

    public static class Builder {
        private String project;
        private String region;
        private String vpnTunnel;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getVpnTunnel() {
            return this.vpnTunnel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setVpnTunnel(String vpnTunnel) {
            this.vpnTunnel = vpnTunnel;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionVpnTunnelName projectRegionVpnTunnelName) {
            this.project = projectRegionVpnTunnelName.project;
            this.region = projectRegionVpnTunnelName.region;
            this.vpnTunnel = projectRegionVpnTunnelName.vpnTunnel;
        }

        public ProjectRegionVpnTunnelName build() {
            return new ProjectRegionVpnTunnelName(this);
        }
    }
}

