/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Route;
import com.google.cloud.compute.v1.RouterStatusBgpPeerStatus;
import com.google.cloud.compute.v1.RouterStatusNatStatus;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RouterStatus
implements ApiMessage {
    private final List<Route> bestRoutes;
    private final List<Route> bestRoutesForRouter;
    private final List<RouterStatusBgpPeerStatus> bgpPeerStatus;
    private final List<RouterStatusNatStatus> natStatus;
    private final String network;
    private static final RouterStatus DEFAULT_INSTANCE = new RouterStatus();

    private RouterStatus() {
        this.bestRoutes = null;
        this.bestRoutesForRouter = null;
        this.bgpPeerStatus = null;
        this.natStatus = null;
        this.network = null;
    }

    private RouterStatus(List<Route> bestRoutes, List<Route> bestRoutesForRouter, List<RouterStatusBgpPeerStatus> bgpPeerStatus, List<RouterStatusNatStatus> natStatus, String network) {
        this.bestRoutes = bestRoutes;
        this.bestRoutesForRouter = bestRoutesForRouter;
        this.bgpPeerStatus = bgpPeerStatus;
        this.natStatus = natStatus;
        this.network = network;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("bestRoutes")) {
            return this.bestRoutes;
        }
        if (fieldName.equals("bestRoutesForRouter")) {
            return this.bestRoutesForRouter;
        }
        if (fieldName.equals("bgpPeerStatus")) {
            return this.bgpPeerStatus;
        }
        if (fieldName.equals("natStatus")) {
            return this.natStatus;
        }
        if (fieldName.equals("network")) {
            return this.network;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Route> getBestRoutesList() {
        return this.bestRoutes;
    }

    public List<Route> getBestRoutesForRouterList() {
        return this.bestRoutesForRouter;
    }

    public List<RouterStatusBgpPeerStatus> getBgpPeerStatusList() {
        return this.bgpPeerStatus;
    }

    public List<RouterStatusNatStatus> getNatStatusList() {
        return this.natStatus;
    }

    public String getNetwork() {
        return this.network;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RouterStatus prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RouterStatus getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RouterStatus{bestRoutes=" + this.bestRoutes + ", bestRoutesForRouter=" + this.bestRoutesForRouter + ", bgpPeerStatus=" + this.bgpPeerStatus + ", natStatus=" + this.natStatus + ", network=" + this.network + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RouterStatus) {
            RouterStatus that = (RouterStatus)o;
            return Objects.equals(this.bestRoutes, that.getBestRoutesList()) && Objects.equals(this.bestRoutesForRouter, that.getBestRoutesForRouterList()) && Objects.equals(this.bgpPeerStatus, that.getBgpPeerStatusList()) && Objects.equals(this.natStatus, that.getNatStatusList()) && Objects.equals(this.network, that.getNetwork());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.bestRoutes, this.bestRoutesForRouter, this.bgpPeerStatus, this.natStatus, this.network);
    }

    public static class Builder {
        private List<Route> bestRoutes;
        private List<Route> bestRoutesForRouter;
        private List<RouterStatusBgpPeerStatus> bgpPeerStatus;
        private List<RouterStatusNatStatus> natStatus;
        private String network;

        Builder() {
        }

        public Builder mergeFrom(RouterStatus other) {
            if (other == RouterStatus.getDefaultInstance()) {
                return this;
            }
            if (other.getBestRoutesList() != null) {
                this.bestRoutes = other.bestRoutes;
            }
            if (other.getBestRoutesForRouterList() != null) {
                this.bestRoutesForRouter = other.bestRoutesForRouter;
            }
            if (other.getBgpPeerStatusList() != null) {
                this.bgpPeerStatus = other.bgpPeerStatus;
            }
            if (other.getNatStatusList() != null) {
                this.natStatus = other.natStatus;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            return this;
        }

        Builder(RouterStatus source) {
            this.bestRoutes = source.bestRoutes;
            this.bestRoutesForRouter = source.bestRoutesForRouter;
            this.bgpPeerStatus = source.bgpPeerStatus;
            this.natStatus = source.natStatus;
            this.network = source.network;
        }

        public List<Route> getBestRoutesList() {
            return this.bestRoutes;
        }

        public Builder addAllBestRoutes(List<Route> bestRoutes) {
            if (this.bestRoutes == null) {
                this.bestRoutes = new LinkedList<Route>();
            }
            this.bestRoutes.addAll(bestRoutes);
            return this;
        }

        public Builder addBestRoutes(Route bestRoutes) {
            if (this.bestRoutes == null) {
                this.bestRoutes = new LinkedList<Route>();
            }
            this.bestRoutes.add(bestRoutes);
            return this;
        }

        public List<Route> getBestRoutesForRouterList() {
            return this.bestRoutesForRouter;
        }

        public Builder addAllBestRoutesForRouter(List<Route> bestRoutesForRouter) {
            if (this.bestRoutesForRouter == null) {
                this.bestRoutesForRouter = new LinkedList<Route>();
            }
            this.bestRoutesForRouter.addAll(bestRoutesForRouter);
            return this;
        }

        public Builder addBestRoutesForRouter(Route bestRoutesForRouter) {
            if (this.bestRoutesForRouter == null) {
                this.bestRoutesForRouter = new LinkedList<Route>();
            }
            this.bestRoutesForRouter.add(bestRoutesForRouter);
            return this;
        }

        public List<RouterStatusBgpPeerStatus> getBgpPeerStatusList() {
            return this.bgpPeerStatus;
        }

        public Builder addAllBgpPeerStatus(List<RouterStatusBgpPeerStatus> bgpPeerStatus) {
            if (this.bgpPeerStatus == null) {
                this.bgpPeerStatus = new LinkedList<RouterStatusBgpPeerStatus>();
            }
            this.bgpPeerStatus.addAll(bgpPeerStatus);
            return this;
        }

        public Builder addBgpPeerStatus(RouterStatusBgpPeerStatus bgpPeerStatus) {
            if (this.bgpPeerStatus == null) {
                this.bgpPeerStatus = new LinkedList<RouterStatusBgpPeerStatus>();
            }
            this.bgpPeerStatus.add(bgpPeerStatus);
            return this;
        }

        public List<RouterStatusNatStatus> getNatStatusList() {
            return this.natStatus;
        }

        public Builder addAllNatStatus(List<RouterStatusNatStatus> natStatus) {
            if (this.natStatus == null) {
                this.natStatus = new LinkedList<RouterStatusNatStatus>();
            }
            this.natStatus.addAll(natStatus);
            return this;
        }

        public Builder addNatStatus(RouterStatusNatStatus natStatus) {
            if (this.natStatus == null) {
                this.natStatus = new LinkedList<RouterStatusNatStatus>();
            }
            this.natStatus.add(natStatus);
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public RouterStatus build() {
            return new RouterStatus(this.bestRoutes, this.bestRoutesForRouter, this.bgpPeerStatus, this.natStatus, this.network);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllBestRoutes(this.bestRoutes);
            newBuilder.addAllBestRoutesForRouter(this.bestRoutesForRouter);
            newBuilder.addAllBgpPeerStatus(this.bgpPeerStatus);
            newBuilder.addAllNatStatus(this.natStatus);
            newBuilder.setNetwork(this.network);
            return newBuilder;
        }
    }
}

