/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SignedUrlKey
implements ApiMessage {
    private final String keyName;
    private final String keyValue;
    private static final SignedUrlKey DEFAULT_INSTANCE = new SignedUrlKey();

    private SignedUrlKey() {
        this.keyName = null;
        this.keyValue = null;
    }

    private SignedUrlKey(String keyName, String keyValue) {
        this.keyName = keyName;
        this.keyValue = keyValue;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("keyName")) {
            return this.keyName;
        }
        if (fieldName.equals("keyValue")) {
            return this.keyValue;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SignedUrlKey prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SignedUrlKey getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SignedUrlKey{keyName=" + this.keyName + ", keyValue=" + this.keyValue + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SignedUrlKey) {
            SignedUrlKey that = (SignedUrlKey)o;
            return Objects.equals(this.keyName, that.getKeyName()) && Objects.equals(this.keyValue, that.getKeyValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyName, this.keyValue);
    }

    public static class Builder {
        private String keyName;
        private String keyValue;

        Builder() {
        }

        public Builder mergeFrom(SignedUrlKey other) {
            if (other == SignedUrlKey.getDefaultInstance()) {
                return this;
            }
            if (other.getKeyName() != null) {
                this.keyName = other.keyName;
            }
            if (other.getKeyValue() != null) {
                this.keyValue = other.keyValue;
            }
            return this;
        }

        Builder(SignedUrlKey source) {
            this.keyName = source.keyName;
            this.keyValue = source.keyValue;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public Builder setKeyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public String getKeyValue() {
            return this.keyValue;
        }

        public Builder setKeyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public SignedUrlKey build() {
            return new SignedUrlKey(this.keyName, this.keyValue);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setKeyName(this.keyName);
            newBuilder.setKeyValue(this.keyValue);
            return newBuilder;
        }
    }
}

