/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TestPermissionsResponse
implements ApiMessage {
    private final List<String> permissions;
    private static final TestPermissionsResponse DEFAULT_INSTANCE = new TestPermissionsResponse();

    private TestPermissionsResponse() {
        this.permissions = null;
    }

    private TestPermissionsResponse(List<String> permissions) {
        this.permissions = permissions;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("permissions")) {
            return this.permissions;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getPermissionsList() {
        return this.permissions;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TestPermissionsResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TestPermissionsResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TestPermissionsResponse{permissions=" + this.permissions + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TestPermissionsResponse) {
            TestPermissionsResponse that = (TestPermissionsResponse)o;
            return Objects.equals(this.permissions, that.getPermissionsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.permissions);
    }

    public static class Builder {
        private List<String> permissions;

        Builder() {
        }

        public Builder mergeFrom(TestPermissionsResponse other) {
            if (other == TestPermissionsResponse.getDefaultInstance()) {
                return this;
            }
            if (other.getPermissionsList() != null) {
                this.permissions = other.permissions;
            }
            return this;
        }

        Builder(TestPermissionsResponse source) {
            this.permissions = source.permissions;
        }

        public List<String> getPermissionsList() {
            return this.permissions;
        }

        public Builder addAllPermissions(List<String> permissions) {
            if (this.permissions == null) {
                this.permissions = new LinkedList<String>();
            }
            this.permissions.addAll(permissions);
            return this;
        }

        public Builder addPermissions(String permissions) {
            if (this.permissions == null) {
                this.permissions = new LinkedList<String>();
            }
            this.permissions.add(permissions);
            return this;
        }

        public TestPermissionsResponse build() {
            return new TestPermissionsResponse(this.permissions);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllPermissions(this.permissions);
            return newBuilder;
        }
    }
}

