/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListVpnTunnelsHttpRequest;
import com.google.cloud.compute.v1.DeleteVpnTunnelHttpRequest;
import com.google.cloud.compute.v1.GetVpnTunnelHttpRequest;
import com.google.cloud.compute.v1.InsertVpnTunnelHttpRequest;
import com.google.cloud.compute.v1.ListVpnTunnelsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionVpnTunnelName;
import com.google.cloud.compute.v1.VpnTunnel;
import com.google.cloud.compute.v1.VpnTunnelAggregatedList;
import com.google.cloud.compute.v1.VpnTunnelList;
import com.google.cloud.compute.v1.VpnTunnelSettings;
import com.google.cloud.compute.v1.VpnTunnelsScopedList;
import com.google.cloud.compute.v1.stub.VpnTunnelStub;
import com.google.cloud.compute.v1.stub.VpnTunnelStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class VpnTunnelClient
implements BackgroundResource {
    private final VpnTunnelSettings settings;
    private final VpnTunnelStub stub;

    public static final VpnTunnelClient create() throws IOException {
        return VpnTunnelClient.create(VpnTunnelSettings.newBuilder().build());
    }

    public static final VpnTunnelClient create(VpnTunnelSettings settings) throws IOException {
        return new VpnTunnelClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final VpnTunnelClient create(VpnTunnelStub stub) {
        return new VpnTunnelClient(stub);
    }

    protected VpnTunnelClient(VpnTunnelSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VpnTunnelStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected VpnTunnelClient(VpnTunnelStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final VpnTunnelSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VpnTunnelStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListVpnTunnelsPagedResponse aggregatedListVpnTunnels(ProjectName project) {
        AggregatedListVpnTunnelsHttpRequest request = AggregatedListVpnTunnelsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListVpnTunnels(request);
    }

    @BetaApi
    public final AggregatedListVpnTunnelsPagedResponse aggregatedListVpnTunnels(String project) {
        AggregatedListVpnTunnelsHttpRequest request = AggregatedListVpnTunnelsHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListVpnTunnels(request);
    }

    @BetaApi
    public final AggregatedListVpnTunnelsPagedResponse aggregatedListVpnTunnels(AggregatedListVpnTunnelsHttpRequest request) {
        return (AggregatedListVpnTunnelsPagedResponse)((Object)this.aggregatedListVpnTunnelsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListVpnTunnelsHttpRequest, AggregatedListVpnTunnelsPagedResponse> aggregatedListVpnTunnelsPagedCallable() {
        return this.stub.aggregatedListVpnTunnelsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList> aggregatedListVpnTunnelsCallable() {
        return this.stub.aggregatedListVpnTunnelsCallable();
    }

    @BetaApi
    public final Operation deleteVpnTunnel(ProjectRegionVpnTunnelName vpnTunnel) {
        DeleteVpnTunnelHttpRequest request = DeleteVpnTunnelHttpRequest.newBuilder().setVpnTunnel(vpnTunnel == null ? null : vpnTunnel.toString()).build();
        return this.deleteVpnTunnel(request);
    }

    @BetaApi
    public final Operation deleteVpnTunnel(String vpnTunnel) {
        DeleteVpnTunnelHttpRequest request = DeleteVpnTunnelHttpRequest.newBuilder().setVpnTunnel(vpnTunnel).build();
        return this.deleteVpnTunnel(request);
    }

    @BetaApi
    public final Operation deleteVpnTunnel(DeleteVpnTunnelHttpRequest request) {
        return (Operation)this.deleteVpnTunnelCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteVpnTunnelHttpRequest, Operation> deleteVpnTunnelCallable() {
        return this.stub.deleteVpnTunnelCallable();
    }

    @BetaApi
    public final VpnTunnel getVpnTunnel(ProjectRegionVpnTunnelName vpnTunnel) {
        GetVpnTunnelHttpRequest request = GetVpnTunnelHttpRequest.newBuilder().setVpnTunnel(vpnTunnel == null ? null : vpnTunnel.toString()).build();
        return this.getVpnTunnel(request);
    }

    @BetaApi
    public final VpnTunnel getVpnTunnel(String vpnTunnel) {
        GetVpnTunnelHttpRequest request = GetVpnTunnelHttpRequest.newBuilder().setVpnTunnel(vpnTunnel).build();
        return this.getVpnTunnel(request);
    }

    @BetaApi
    public final VpnTunnel getVpnTunnel(GetVpnTunnelHttpRequest request) {
        return (VpnTunnel)this.getVpnTunnelCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetVpnTunnelHttpRequest, VpnTunnel> getVpnTunnelCallable() {
        return this.stub.getVpnTunnelCallable();
    }

    @BetaApi
    public final Operation insertVpnTunnel(ProjectRegionName region, VpnTunnel vpnTunnelResource) {
        InsertVpnTunnelHttpRequest request = InsertVpnTunnelHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setVpnTunnelResource(vpnTunnelResource).build();
        return this.insertVpnTunnel(request);
    }

    @BetaApi
    public final Operation insertVpnTunnel(String region, VpnTunnel vpnTunnelResource) {
        InsertVpnTunnelHttpRequest request = InsertVpnTunnelHttpRequest.newBuilder().setRegion(region).setVpnTunnelResource(vpnTunnelResource).build();
        return this.insertVpnTunnel(request);
    }

    @BetaApi
    public final Operation insertVpnTunnel(InsertVpnTunnelHttpRequest request) {
        return (Operation)this.insertVpnTunnelCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertVpnTunnelHttpRequest, Operation> insertVpnTunnelCallable() {
        return this.stub.insertVpnTunnelCallable();
    }

    @BetaApi
    public final ListVpnTunnelsPagedResponse listVpnTunnels(ProjectRegionName region) {
        ListVpnTunnelsHttpRequest request = ListVpnTunnelsHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listVpnTunnels(request);
    }

    @BetaApi
    public final ListVpnTunnelsPagedResponse listVpnTunnels(String region) {
        ListVpnTunnelsHttpRequest request = ListVpnTunnelsHttpRequest.newBuilder().setRegion(region).build();
        return this.listVpnTunnels(request);
    }

    @BetaApi
    public final ListVpnTunnelsPagedResponse listVpnTunnels(ListVpnTunnelsHttpRequest request) {
        return (ListVpnTunnelsPagedResponse)((Object)this.listVpnTunnelsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListVpnTunnelsHttpRequest, ListVpnTunnelsPagedResponse> listVpnTunnelsPagedCallable() {
        return this.stub.listVpnTunnelsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListVpnTunnelsHttpRequest, VpnTunnelList> listVpnTunnelsCallable() {
        return this.stub.listVpnTunnelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListVpnTunnelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnel, ListVpnTunnelsPage, ListVpnTunnelsFixedSizeCollection> {
        private ListVpnTunnelsFixedSizeCollection(List<ListVpnTunnelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVpnTunnelsFixedSizeCollection createEmptyCollection() {
            return new ListVpnTunnelsFixedSizeCollection(null, 0);
        }

        protected ListVpnTunnelsFixedSizeCollection createCollection(List<ListVpnTunnelsPage> pages, int collectionSize) {
            return new ListVpnTunnelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVpnTunnelsPage
    extends AbstractPage<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnel, ListVpnTunnelsPage> {
        private ListVpnTunnelsPage(PageContext<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnel> context, VpnTunnelList response) {
            super(context, (Object)response);
        }

        private static ListVpnTunnelsPage createEmptyPage() {
            return new ListVpnTunnelsPage(null, null);
        }

        protected ListVpnTunnelsPage createPage(PageContext<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnel> context, VpnTunnelList response) {
            return new ListVpnTunnelsPage(context, response);
        }

        public ApiFuture<ListVpnTunnelsPage> createPageAsync(PageContext<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnel> context, ApiFuture<VpnTunnelList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVpnTunnelsPagedResponse
    extends AbstractPagedListResponse<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnel, ListVpnTunnelsPage, ListVpnTunnelsFixedSizeCollection> {
        public static ApiFuture<ListVpnTunnelsPagedResponse> createAsync(PageContext<ListVpnTunnelsHttpRequest, VpnTunnelList, VpnTunnel> context, ApiFuture<VpnTunnelList> futureResponse) {
            ApiFuture<ListVpnTunnelsPage> futurePage = ListVpnTunnelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListVpnTunnelsPage, ListVpnTunnelsPagedResponse>(){

                public ListVpnTunnelsPagedResponse apply(ListVpnTunnelsPage input) {
                    return new ListVpnTunnelsPagedResponse(input);
                }
            });
        }

        private ListVpnTunnelsPagedResponse(ListVpnTunnelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVpnTunnelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListVpnTunnelsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelsScopedList, AggregatedListVpnTunnelsPage, AggregatedListVpnTunnelsFixedSizeCollection> {
        private AggregatedListVpnTunnelsFixedSizeCollection(List<AggregatedListVpnTunnelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListVpnTunnelsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListVpnTunnelsFixedSizeCollection(null, 0);
        }

        protected AggregatedListVpnTunnelsFixedSizeCollection createCollection(List<AggregatedListVpnTunnelsPage> pages, int collectionSize) {
            return new AggregatedListVpnTunnelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListVpnTunnelsPage
    extends AbstractPage<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelsScopedList, AggregatedListVpnTunnelsPage> {
        private AggregatedListVpnTunnelsPage(PageContext<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelsScopedList> context, VpnTunnelAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListVpnTunnelsPage createEmptyPage() {
            return new AggregatedListVpnTunnelsPage(null, null);
        }

        protected AggregatedListVpnTunnelsPage createPage(PageContext<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelsScopedList> context, VpnTunnelAggregatedList response) {
            return new AggregatedListVpnTunnelsPage(context, response);
        }

        public ApiFuture<AggregatedListVpnTunnelsPage> createPageAsync(PageContext<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelsScopedList> context, ApiFuture<VpnTunnelAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListVpnTunnelsPagedResponse
    extends AbstractPagedListResponse<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelsScopedList, AggregatedListVpnTunnelsPage, AggregatedListVpnTunnelsFixedSizeCollection> {
        public static ApiFuture<AggregatedListVpnTunnelsPagedResponse> createAsync(PageContext<AggregatedListVpnTunnelsHttpRequest, VpnTunnelAggregatedList, VpnTunnelsScopedList> context, ApiFuture<VpnTunnelAggregatedList> futureResponse) {
            ApiFuture<AggregatedListVpnTunnelsPage> futurePage = AggregatedListVpnTunnelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListVpnTunnelsPage, AggregatedListVpnTunnelsPagedResponse>(){

                public AggregatedListVpnTunnelsPagedResponse apply(AggregatedListVpnTunnelsPage input) {
                    return new AggregatedListVpnTunnelsPagedResponse(input);
                }
            });
        }

        private AggregatedListVpnTunnelsPagedResponse(AggregatedListVpnTunnelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListVpnTunnelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

