/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteInterconnectHttpRequest;
import com.google.cloud.compute.v1.GetDiagnosticsInterconnectHttpRequest;
import com.google.cloud.compute.v1.GetInterconnectHttpRequest;
import com.google.cloud.compute.v1.InsertInterconnectHttpRequest;
import com.google.cloud.compute.v1.Interconnect;
import com.google.cloud.compute.v1.InterconnectClient;
import com.google.cloud.compute.v1.InterconnectList;
import com.google.cloud.compute.v1.InterconnectsGetDiagnosticsResponse;
import com.google.cloud.compute.v1.ListInterconnectsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalInterconnectName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.stub.HttpJsonInterconnectCallableFactory;
import com.google.cloud.compute.v1.stub.InterconnectStub;
import com.google.cloud.compute.v1.stub.InterconnectStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonInterconnectStub
extends InterconnectStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteInterconnectHttpRequest, Operation> deleteInterconnectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.interconnects.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/interconnects/{interconnect}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalInterconnectName.newFactory()).setResourceNameField("interconnect").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetInterconnectHttpRequest, Interconnect> getInterconnectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.interconnects.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/interconnects/{interconnect}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalInterconnectName.newFactory()).setResourceNameField("interconnect").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Interconnect.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetDiagnosticsInterconnectHttpRequest, InterconnectsGetDiagnosticsResponse> getDiagnosticsInterconnectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.interconnects.getDiagnostics").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/interconnects/{interconnect}/getDiagnostics")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalInterconnectName.newFactory()).setResourceNameField("interconnect").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)InterconnectsGetDiagnosticsResponse.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertInterconnectHttpRequest, Operation> insertInterconnectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.interconnects.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/interconnects")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListInterconnectsHttpRequest, InterconnectList> listInterconnectsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.interconnects.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/interconnects")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)InterconnectList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchInterconnectHttpRequest, Operation> patchInterconnectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.interconnects.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/interconnects/{interconnect}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalInterconnectName.newFactory()).setResourceNameField("interconnect").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteInterconnectHttpRequest, Operation> deleteInterconnectCallable;
    private final UnaryCallable<GetInterconnectHttpRequest, Interconnect> getInterconnectCallable;
    private final UnaryCallable<GetDiagnosticsInterconnectHttpRequest, InterconnectsGetDiagnosticsResponse> getDiagnosticsInterconnectCallable;
    private final UnaryCallable<InsertInterconnectHttpRequest, Operation> insertInterconnectCallable;
    private final UnaryCallable<ListInterconnectsHttpRequest, InterconnectList> listInterconnectsCallable;
    private final UnaryCallable<ListInterconnectsHttpRequest, InterconnectClient.ListInterconnectsPagedResponse> listInterconnectsPagedCallable;
    private final UnaryCallable<PatchInterconnectHttpRequest, Operation> patchInterconnectCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonInterconnectStub create(InterconnectStubSettings settings) throws IOException {
        return new HttpJsonInterconnectStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonInterconnectStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonInterconnectStub(InterconnectStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonInterconnectStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonInterconnectStub(InterconnectStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonInterconnectStub(InterconnectStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonInterconnectCallableFactory());
    }

    protected HttpJsonInterconnectStub(InterconnectStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteInterconnectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteInterconnectMethodDescriptor).build();
        HttpJsonCallSettings getInterconnectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getInterconnectMethodDescriptor).build();
        HttpJsonCallSettings getDiagnosticsInterconnectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDiagnosticsInterconnectMethodDescriptor).build();
        HttpJsonCallSettings insertInterconnectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertInterconnectMethodDescriptor).build();
        HttpJsonCallSettings listInterconnectsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listInterconnectsMethodDescriptor).build();
        HttpJsonCallSettings patchInterconnectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchInterconnectMethodDescriptor).build();
        this.deleteInterconnectCallable = callableFactory.createUnaryCallable(deleteInterconnectTransportSettings, settings.deleteInterconnectSettings(), clientContext);
        this.getInterconnectCallable = callableFactory.createUnaryCallable(getInterconnectTransportSettings, settings.getInterconnectSettings(), clientContext);
        this.getDiagnosticsInterconnectCallable = callableFactory.createUnaryCallable(getDiagnosticsInterconnectTransportSettings, settings.getDiagnosticsInterconnectSettings(), clientContext);
        this.insertInterconnectCallable = callableFactory.createUnaryCallable(insertInterconnectTransportSettings, settings.insertInterconnectSettings(), clientContext);
        this.listInterconnectsCallable = callableFactory.createUnaryCallable(listInterconnectsTransportSettings, settings.listInterconnectsSettings(), clientContext);
        this.listInterconnectsPagedCallable = callableFactory.createPagedCallable(listInterconnectsTransportSettings, settings.listInterconnectsSettings(), clientContext);
        this.patchInterconnectCallable = callableFactory.createUnaryCallable(patchInterconnectTransportSettings, settings.patchInterconnectSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteInterconnectHttpRequest, Operation> deleteInterconnectCallable() {
        return this.deleteInterconnectCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetInterconnectHttpRequest, Interconnect> getInterconnectCallable() {
        return this.getInterconnectCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetDiagnosticsInterconnectHttpRequest, InterconnectsGetDiagnosticsResponse> getDiagnosticsInterconnectCallable() {
        return this.getDiagnosticsInterconnectCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertInterconnectHttpRequest, Operation> insertInterconnectCallable() {
        return this.insertInterconnectCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListInterconnectsHttpRequest, InterconnectClient.ListInterconnectsPagedResponse> listInterconnectsPagedCallable() {
        return this.listInterconnectsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListInterconnectsHttpRequest, InterconnectList> listInterconnectsCallable() {
        return this.listInterconnectsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchInterconnectHttpRequest, Operation> patchInterconnectCallable() {
        return this.patchInterconnectCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

