/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.DeprecationStatus;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class DiskType
implements ApiMessage {
    private final String creationTimestamp;
    private final String defaultDiskSizeGb;
    private final DeprecationStatus deprecated;
    private final String description;
    private final String id;
    private final String kind;
    private final String name;
    private final String region;
    private final String selfLink;
    private final String validDiskSize;
    private final String zone;
    private static final DiskType DEFAULT_INSTANCE = new DiskType();

    private DiskType() {
        this.creationTimestamp = null;
        this.defaultDiskSizeGb = null;
        this.deprecated = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.region = null;
        this.selfLink = null;
        this.validDiskSize = null;
        this.zone = null;
    }

    private DiskType(String creationTimestamp, String defaultDiskSizeGb, DeprecationStatus deprecated, String description, String id, String kind, String name, String region, String selfLink, String validDiskSize, String zone) {
        this.creationTimestamp = creationTimestamp;
        this.defaultDiskSizeGb = defaultDiskSizeGb;
        this.deprecated = deprecated;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.region = region;
        this.selfLink = selfLink;
        this.validDiskSize = validDiskSize;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("defaultDiskSizeGb".equals(fieldName)) {
            return this.defaultDiskSizeGb;
        }
        if ("deprecated".equals(fieldName)) {
            return this.deprecated;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("validDiskSize".equals(fieldName)) {
            return this.validDiskSize;
        }
        if ("zone".equals(fieldName)) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDefaultDiskSizeGb() {
        return this.defaultDiskSizeGb;
    }

    public DeprecationStatus getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getValidDiskSize() {
        return this.validDiskSize;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DiskType prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static DiskType getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "DiskType{creationTimestamp=" + this.creationTimestamp + ", defaultDiskSizeGb=" + this.defaultDiskSizeGb + ", deprecated=" + this.deprecated + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", region=" + this.region + ", selfLink=" + this.selfLink + ", validDiskSize=" + this.validDiskSize + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DiskType) {
            DiskType that = (DiskType)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.defaultDiskSizeGb, that.getDefaultDiskSizeGb()) && Objects.equals(this.deprecated, that.getDeprecated()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.validDiskSize, that.getValidDiskSize()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.defaultDiskSizeGb, this.deprecated, this.description, this.id, this.kind, this.name, this.region, this.selfLink, this.validDiskSize, this.zone);
    }

    public static class Builder {
        private String creationTimestamp;
        private String defaultDiskSizeGb;
        private DeprecationStatus deprecated;
        private String description;
        private String id;
        private String kind;
        private String name;
        private String region;
        private String selfLink;
        private String validDiskSize;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(DiskType other) {
            if (other == DiskType.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDefaultDiskSizeGb() != null) {
                this.defaultDiskSizeGb = other.defaultDiskSizeGb;
            }
            if (other.getDeprecated() != null) {
                this.deprecated = other.deprecated;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getValidDiskSize() != null) {
                this.validDiskSize = other.validDiskSize;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(DiskType source) {
            this.creationTimestamp = source.creationTimestamp;
            this.defaultDiskSizeGb = source.defaultDiskSizeGb;
            this.deprecated = source.deprecated;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.validDiskSize = source.validDiskSize;
            this.zone = source.zone;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDefaultDiskSizeGb() {
            return this.defaultDiskSizeGb;
        }

        public Builder setDefaultDiskSizeGb(String defaultDiskSizeGb) {
            this.defaultDiskSizeGb = defaultDiskSizeGb;
            return this;
        }

        public DeprecationStatus getDeprecated() {
            return this.deprecated;
        }

        public Builder setDeprecated(DeprecationStatus deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getValidDiskSize() {
            return this.validDiskSize;
        }

        public Builder setValidDiskSize(String validDiskSize) {
            this.validDiskSize = validDiskSize;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public DiskType build() {
            return new DiskType(this.creationTimestamp, this.defaultDiskSizeGb, this.deprecated, this.description, this.id, this.kind, this.name, this.region, this.selfLink, this.validDiskSize, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDefaultDiskSizeGb(this.defaultDiskSizeGb);
            newBuilder.setDeprecated(this.deprecated);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setValidDiskSize(this.validDiskSize);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

