/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class FixedOrPercent
implements ApiMessage {
    private final Integer calculated;
    private final Integer fixed;
    private final Integer percent;
    private static final FixedOrPercent DEFAULT_INSTANCE = new FixedOrPercent();

    private FixedOrPercent() {
        this.calculated = null;
        this.fixed = null;
        this.percent = null;
    }

    private FixedOrPercent(Integer calculated, Integer fixed, Integer percent) {
        this.calculated = calculated;
        this.fixed = fixed;
        this.percent = percent;
    }

    public Object getFieldValue(String fieldName) {
        if ("calculated".equals(fieldName)) {
            return this.calculated;
        }
        if ("fixed".equals(fieldName)) {
            return this.fixed;
        }
        if ("percent".equals(fieldName)) {
            return this.percent;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Integer getCalculated() {
        return this.calculated;
    }

    public Integer getFixed() {
        return this.fixed;
    }

    public Integer getPercent() {
        return this.percent;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(FixedOrPercent prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static FixedOrPercent getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "FixedOrPercent{calculated=" + this.calculated + ", fixed=" + this.fixed + ", percent=" + this.percent + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FixedOrPercent) {
            FixedOrPercent that = (FixedOrPercent)o;
            return Objects.equals(this.calculated, that.getCalculated()) && Objects.equals(this.fixed, that.getFixed()) && Objects.equals(this.percent, that.getPercent());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.calculated, this.fixed, this.percent);
    }

    public static class Builder {
        private Integer calculated;
        private Integer fixed;
        private Integer percent;

        Builder() {
        }

        public Builder mergeFrom(FixedOrPercent other) {
            if (other == FixedOrPercent.getDefaultInstance()) {
                return this;
            }
            if (other.getCalculated() != null) {
                this.calculated = other.calculated;
            }
            if (other.getFixed() != null) {
                this.fixed = other.fixed;
            }
            if (other.getPercent() != null) {
                this.percent = other.percent;
            }
            return this;
        }

        Builder(FixedOrPercent source) {
            this.calculated = source.calculated;
            this.fixed = source.fixed;
            this.percent = source.percent;
        }

        public Integer getCalculated() {
            return this.calculated;
        }

        public Builder setCalculated(Integer calculated) {
            this.calculated = calculated;
            return this;
        }

        public Integer getFixed() {
            return this.fixed;
        }

        public Builder setFixed(Integer fixed) {
            this.fixed = fixed;
            return this;
        }

        public Integer getPercent() {
            return this.percent;
        }

        public Builder setPercent(Integer percent) {
            this.percent = percent;
            return this;
        }

        public FixedOrPercent build() {
            return new FixedOrPercent(this.calculated, this.fixed, this.percent);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCalculated(this.calculated);
            newBuilder.setFixed(this.fixed);
            newBuilder.setPercent(this.percent);
            return newBuilder;
        }
    }
}

