/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListForwardingRulesHttpRequest;
import com.google.cloud.compute.v1.DeleteForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.ForwardingRule;
import com.google.cloud.compute.v1.ForwardingRuleAggregatedList;
import com.google.cloud.compute.v1.ForwardingRuleList;
import com.google.cloud.compute.v1.ForwardingRuleSettings;
import com.google.cloud.compute.v1.ForwardingRulesScopedList;
import com.google.cloud.compute.v1.GetForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.InsertForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.ListForwardingRulesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionForwardingRuleName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.SetTargetForwardingRuleHttpRequest;
import com.google.cloud.compute.v1.TargetReference;
import com.google.cloud.compute.v1.stub.ForwardingRuleStub;
import com.google.cloud.compute.v1.stub.ForwardingRuleStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ForwardingRuleClient
implements BackgroundResource {
    private final ForwardingRuleSettings settings;
    private final ForwardingRuleStub stub;

    public static final ForwardingRuleClient create() throws IOException {
        return ForwardingRuleClient.create(ForwardingRuleSettings.newBuilder().build());
    }

    public static final ForwardingRuleClient create(ForwardingRuleSettings settings) throws IOException {
        return new ForwardingRuleClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ForwardingRuleClient create(ForwardingRuleStub stub) {
        return new ForwardingRuleClient(stub);
    }

    protected ForwardingRuleClient(ForwardingRuleSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ForwardingRuleStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ForwardingRuleClient(ForwardingRuleStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ForwardingRuleSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ForwardingRuleStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListForwardingRulesPagedResponse aggregatedListForwardingRules(ProjectName project) {
        AggregatedListForwardingRulesHttpRequest request = AggregatedListForwardingRulesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListForwardingRules(request);
    }

    @BetaApi
    public final AggregatedListForwardingRulesPagedResponse aggregatedListForwardingRules(String project) {
        AggregatedListForwardingRulesHttpRequest request = AggregatedListForwardingRulesHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListForwardingRules(request);
    }

    @BetaApi
    public final AggregatedListForwardingRulesPagedResponse aggregatedListForwardingRules(AggregatedListForwardingRulesHttpRequest request) {
        return (AggregatedListForwardingRulesPagedResponse)((Object)this.aggregatedListForwardingRulesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListForwardingRulesHttpRequest, AggregatedListForwardingRulesPagedResponse> aggregatedListForwardingRulesPagedCallable() {
        return this.stub.aggregatedListForwardingRulesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList> aggregatedListForwardingRulesCallable() {
        return this.stub.aggregatedListForwardingRulesCallable();
    }

    @BetaApi
    public final Operation deleteForwardingRule(ProjectRegionForwardingRuleName forwardingRule) {
        DeleteForwardingRuleHttpRequest request = DeleteForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule == null ? null : forwardingRule.toString()).build();
        return this.deleteForwardingRule(request);
    }

    @BetaApi
    public final Operation deleteForwardingRule(String forwardingRule) {
        DeleteForwardingRuleHttpRequest request = DeleteForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule).build();
        return this.deleteForwardingRule(request);
    }

    @BetaApi
    public final Operation deleteForwardingRule(DeleteForwardingRuleHttpRequest request) {
        return (Operation)this.deleteForwardingRuleCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteForwardingRuleHttpRequest, Operation> deleteForwardingRuleCallable() {
        return this.stub.deleteForwardingRuleCallable();
    }

    @BetaApi
    public final ForwardingRule getForwardingRule(ProjectRegionForwardingRuleName forwardingRule) {
        GetForwardingRuleHttpRequest request = GetForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule == null ? null : forwardingRule.toString()).build();
        return this.getForwardingRule(request);
    }

    @BetaApi
    public final ForwardingRule getForwardingRule(String forwardingRule) {
        GetForwardingRuleHttpRequest request = GetForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule).build();
        return this.getForwardingRule(request);
    }

    @BetaApi
    public final ForwardingRule getForwardingRule(GetForwardingRuleHttpRequest request) {
        return (ForwardingRule)this.getForwardingRuleCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetForwardingRuleHttpRequest, ForwardingRule> getForwardingRuleCallable() {
        return this.stub.getForwardingRuleCallable();
    }

    @BetaApi
    public final Operation insertForwardingRule(ProjectRegionName region, ForwardingRule forwardingRuleResource) {
        InsertForwardingRuleHttpRequest request = InsertForwardingRuleHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setForwardingRuleResource(forwardingRuleResource).build();
        return this.insertForwardingRule(request);
    }

    @BetaApi
    public final Operation insertForwardingRule(String region, ForwardingRule forwardingRuleResource) {
        InsertForwardingRuleHttpRequest request = InsertForwardingRuleHttpRequest.newBuilder().setRegion(region).setForwardingRuleResource(forwardingRuleResource).build();
        return this.insertForwardingRule(request);
    }

    @BetaApi
    public final Operation insertForwardingRule(InsertForwardingRuleHttpRequest request) {
        return (Operation)this.insertForwardingRuleCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertForwardingRuleHttpRequest, Operation> insertForwardingRuleCallable() {
        return this.stub.insertForwardingRuleCallable();
    }

    @BetaApi
    public final ListForwardingRulesPagedResponse listForwardingRules(ProjectRegionName region) {
        ListForwardingRulesHttpRequest request = ListForwardingRulesHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listForwardingRules(request);
    }

    @BetaApi
    public final ListForwardingRulesPagedResponse listForwardingRules(String region) {
        ListForwardingRulesHttpRequest request = ListForwardingRulesHttpRequest.newBuilder().setRegion(region).build();
        return this.listForwardingRules(request);
    }

    @BetaApi
    public final ListForwardingRulesPagedResponse listForwardingRules(ListForwardingRulesHttpRequest request) {
        return (ListForwardingRulesPagedResponse)((Object)this.listForwardingRulesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListForwardingRulesHttpRequest, ListForwardingRulesPagedResponse> listForwardingRulesPagedCallable() {
        return this.stub.listForwardingRulesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListForwardingRulesHttpRequest, ForwardingRuleList> listForwardingRulesCallable() {
        return this.stub.listForwardingRulesCallable();
    }

    @BetaApi
    public final Operation setTargetForwardingRule(ProjectRegionForwardingRuleName forwardingRule, TargetReference targetReferenceResource) {
        SetTargetForwardingRuleHttpRequest request = SetTargetForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule == null ? null : forwardingRule.toString()).setTargetReferenceResource(targetReferenceResource).build();
        return this.setTargetForwardingRule(request);
    }

    @BetaApi
    public final Operation setTargetForwardingRule(String forwardingRule, TargetReference targetReferenceResource) {
        SetTargetForwardingRuleHttpRequest request = SetTargetForwardingRuleHttpRequest.newBuilder().setForwardingRule(forwardingRule).setTargetReferenceResource(targetReferenceResource).build();
        return this.setTargetForwardingRule(request);
    }

    @BetaApi
    public final Operation setTargetForwardingRule(SetTargetForwardingRuleHttpRequest request) {
        return (Operation)this.setTargetForwardingRuleCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetTargetForwardingRuleHttpRequest, Operation> setTargetForwardingRuleCallable() {
        return this.stub.setTargetForwardingRuleCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListForwardingRulesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule, ListForwardingRulesPage, ListForwardingRulesFixedSizeCollection> {
        private ListForwardingRulesFixedSizeCollection(List<ListForwardingRulesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListForwardingRulesFixedSizeCollection createEmptyCollection() {
            return new ListForwardingRulesFixedSizeCollection(null, 0);
        }

        protected ListForwardingRulesFixedSizeCollection createCollection(List<ListForwardingRulesPage> pages, int collectionSize) {
            return new ListForwardingRulesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListForwardingRulesPage
    extends AbstractPage<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule, ListForwardingRulesPage> {
        private ListForwardingRulesPage(PageContext<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule> context, ForwardingRuleList response) {
            super(context, (Object)response);
        }

        private static ListForwardingRulesPage createEmptyPage() {
            return new ListForwardingRulesPage(null, null);
        }

        protected ListForwardingRulesPage createPage(PageContext<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule> context, ForwardingRuleList response) {
            return new ListForwardingRulesPage(context, response);
        }

        public ApiFuture<ListForwardingRulesPage> createPageAsync(PageContext<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule> context, ApiFuture<ForwardingRuleList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListForwardingRulesPagedResponse
    extends AbstractPagedListResponse<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule, ListForwardingRulesPage, ListForwardingRulesFixedSizeCollection> {
        public static ApiFuture<ListForwardingRulesPagedResponse> createAsync(PageContext<ListForwardingRulesHttpRequest, ForwardingRuleList, ForwardingRule> context, ApiFuture<ForwardingRuleList> futureResponse) {
            ApiFuture<ListForwardingRulesPage> futurePage = ListForwardingRulesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListForwardingRulesPage, ListForwardingRulesPagedResponse>(){

                public ListForwardingRulesPagedResponse apply(ListForwardingRulesPage input) {
                    return new ListForwardingRulesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListForwardingRulesPagedResponse(ListForwardingRulesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListForwardingRulesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListForwardingRulesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRulesScopedList, AggregatedListForwardingRulesPage, AggregatedListForwardingRulesFixedSizeCollection> {
        private AggregatedListForwardingRulesFixedSizeCollection(List<AggregatedListForwardingRulesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListForwardingRulesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListForwardingRulesFixedSizeCollection(null, 0);
        }

        protected AggregatedListForwardingRulesFixedSizeCollection createCollection(List<AggregatedListForwardingRulesPage> pages, int collectionSize) {
            return new AggregatedListForwardingRulesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListForwardingRulesPage
    extends AbstractPage<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRulesScopedList, AggregatedListForwardingRulesPage> {
        private AggregatedListForwardingRulesPage(PageContext<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRulesScopedList> context, ForwardingRuleAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListForwardingRulesPage createEmptyPage() {
            return new AggregatedListForwardingRulesPage(null, null);
        }

        protected AggregatedListForwardingRulesPage createPage(PageContext<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRulesScopedList> context, ForwardingRuleAggregatedList response) {
            return new AggregatedListForwardingRulesPage(context, response);
        }

        public ApiFuture<AggregatedListForwardingRulesPage> createPageAsync(PageContext<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRulesScopedList> context, ApiFuture<ForwardingRuleAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListForwardingRulesPagedResponse
    extends AbstractPagedListResponse<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRulesScopedList, AggregatedListForwardingRulesPage, AggregatedListForwardingRulesFixedSizeCollection> {
        public static ApiFuture<AggregatedListForwardingRulesPagedResponse> createAsync(PageContext<AggregatedListForwardingRulesHttpRequest, ForwardingRuleAggregatedList, ForwardingRulesScopedList> context, ApiFuture<ForwardingRuleAggregatedList> futureResponse) {
            ApiFuture<AggregatedListForwardingRulesPage> futurePage = AggregatedListForwardingRulesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListForwardingRulesPage, AggregatedListForwardingRulesPagedResponse>(){

                public AggregatedListForwardingRulesPagedResponse apply(AggregatedListForwardingRulesPage input) {
                    return new AggregatedListForwardingRulesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListForwardingRulesPagedResponse(AggregatedListForwardingRulesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListForwardingRulesFixedSizeCollection.createEmptyCollection());
        }
    }
}

