/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.NamedPort;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroup
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String fingerprint;
    private final String id;
    private final String kind;
    private final String name;
    private final List<NamedPort> namedPorts;
    private final String network;
    private final String region;
    private final String selfLink;
    private final Integer size;
    private final String subnetwork;
    private final String zone;
    private static final InstanceGroup DEFAULT_INSTANCE = new InstanceGroup();

    private InstanceGroup() {
        this.creationTimestamp = null;
        this.description = null;
        this.fingerprint = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.namedPorts = null;
        this.network = null;
        this.region = null;
        this.selfLink = null;
        this.size = null;
        this.subnetwork = null;
        this.zone = null;
    }

    private InstanceGroup(String creationTimestamp, String description, String fingerprint, String id, String kind, String name, List<NamedPort> namedPorts, String network, String region, String selfLink, Integer size, String subnetwork, String zone) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.fingerprint = fingerprint;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.namedPorts = namedPorts;
        this.network = network;
        this.region = region;
        this.selfLink = selfLink;
        this.size = size;
        this.subnetwork = subnetwork;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("fingerprint".equals(fieldName)) {
            return this.fingerprint;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("namedPorts".equals(fieldName)) {
            return this.namedPorts;
        }
        if ("network".equals(fieldName)) {
            return this.network;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("size".equals(fieldName)) {
            return this.size;
        }
        if ("subnetwork".equals(fieldName)) {
            return this.subnetwork;
        }
        if ("zone".equals(fieldName)) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public List<NamedPort> getNamedPortsList() {
        return this.namedPorts;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroup prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroup getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroup{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", fingerprint=" + this.fingerprint + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", namedPorts=" + this.namedPorts + ", network=" + this.network + ", region=" + this.region + ", selfLink=" + this.selfLink + ", size=" + this.size + ", subnetwork=" + this.subnetwork + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroup) {
            InstanceGroup that = (InstanceGroup)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.namedPorts, that.getNamedPortsList()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.size, that.getSize()) && Objects.equals(this.subnetwork, that.getSubnetwork()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.fingerprint, this.id, this.kind, this.name, this.namedPorts, this.network, this.region, this.selfLink, this.size, this.subnetwork, this.zone);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String fingerprint;
        private String id;
        private String kind;
        private String name;
        private List<NamedPort> namedPorts;
        private String network;
        private String region;
        private String selfLink;
        private Integer size;
        private String subnetwork;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroup other) {
            if (other == InstanceGroup.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNamedPortsList() != null) {
                this.namedPorts = other.namedPorts;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSize() != null) {
                this.size = other.size;
            }
            if (other.getSubnetwork() != null) {
                this.subnetwork = other.subnetwork;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(InstanceGroup source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.fingerprint = source.fingerprint;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.namedPorts = source.namedPorts;
            this.network = source.network;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.size = source.size;
            this.subnetwork = source.subnetwork;
            this.zone = source.zone;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<NamedPort> getNamedPortsList() {
            return this.namedPorts;
        }

        public Builder addAllNamedPorts(List<NamedPort> namedPorts) {
            if (this.namedPorts == null) {
                this.namedPorts = new LinkedList<NamedPort>();
            }
            this.namedPorts.addAll(namedPorts);
            return this;
        }

        public Builder addNamedPorts(NamedPort namedPorts) {
            if (this.namedPorts == null) {
                this.namedPorts = new LinkedList<NamedPort>();
            }
            this.namedPorts.add(namedPorts);
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Integer getSize() {
            return this.size;
        }

        public Builder setSize(Integer size) {
            this.size = size;
            return this;
        }

        public String getSubnetwork() {
            return this.subnetwork;
        }

        public Builder setSubnetwork(String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public InstanceGroup build() {
            return new InstanceGroup(this.creationTimestamp, this.description, this.fingerprint, this.id, this.kind, this.name, this.namedPorts, this.network, this.region, this.selfLink, this.size, this.subnetwork, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.addAllNamedPorts(this.namedPorts);
            newBuilder.setNetwork(this.network);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setSize(this.size);
            newBuilder.setSubnetwork(this.subnetwork);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

