/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InterconnectOutageNotification
implements ApiMessage {
    private final List<String> affectedCircuits;
    private final String description;
    private final String endTime;
    private final String issueType;
    private final String name;
    private final String source;
    private final String startTime;
    private final String state;
    private static final InterconnectOutageNotification DEFAULT_INSTANCE = new InterconnectOutageNotification();

    private InterconnectOutageNotification() {
        this.affectedCircuits = null;
        this.description = null;
        this.endTime = null;
        this.issueType = null;
        this.name = null;
        this.source = null;
        this.startTime = null;
        this.state = null;
    }

    private InterconnectOutageNotification(List<String> affectedCircuits, String description, String endTime, String issueType, String name, String source, String startTime, String state) {
        this.affectedCircuits = affectedCircuits;
        this.description = description;
        this.endTime = endTime;
        this.issueType = issueType;
        this.name = name;
        this.source = source;
        this.startTime = startTime;
        this.state = state;
    }

    public Object getFieldValue(String fieldName) {
        if ("affectedCircuits".equals(fieldName)) {
            return this.affectedCircuits;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("endTime".equals(fieldName)) {
            return this.endTime;
        }
        if ("issueType".equals(fieldName)) {
            return this.issueType;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("source".equals(fieldName)) {
            return this.source;
        }
        if ("startTime".equals(fieldName)) {
            return this.startTime;
        }
        if ("state".equals(fieldName)) {
            return this.state;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getAffectedCircuitsList() {
        return this.affectedCircuits;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getState() {
        return this.state;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InterconnectOutageNotification prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InterconnectOutageNotification getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InterconnectOutageNotification{affectedCircuits=" + this.affectedCircuits + ", description=" + this.description + ", endTime=" + this.endTime + ", issueType=" + this.issueType + ", name=" + this.name + ", source=" + this.source + ", startTime=" + this.startTime + ", state=" + this.state + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InterconnectOutageNotification) {
            InterconnectOutageNotification that = (InterconnectOutageNotification)o;
            return Objects.equals(this.affectedCircuits, that.getAffectedCircuitsList()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.endTime, that.getEndTime()) && Objects.equals(this.issueType, that.getIssueType()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.source, that.getSource()) && Objects.equals(this.startTime, that.getStartTime()) && Objects.equals(this.state, that.getState());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.affectedCircuits, this.description, this.endTime, this.issueType, this.name, this.source, this.startTime, this.state);
    }

    public static class Builder {
        private List<String> affectedCircuits;
        private String description;
        private String endTime;
        private String issueType;
        private String name;
        private String source;
        private String startTime;
        private String state;

        Builder() {
        }

        public Builder mergeFrom(InterconnectOutageNotification other) {
            if (other == InterconnectOutageNotification.getDefaultInstance()) {
                return this;
            }
            if (other.getAffectedCircuitsList() != null) {
                this.affectedCircuits = other.affectedCircuits;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getEndTime() != null) {
                this.endTime = other.endTime;
            }
            if (other.getIssueType() != null) {
                this.issueType = other.issueType;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getSource() != null) {
                this.source = other.source;
            }
            if (other.getStartTime() != null) {
                this.startTime = other.startTime;
            }
            if (other.getState() != null) {
                this.state = other.state;
            }
            return this;
        }

        Builder(InterconnectOutageNotification source) {
            this.affectedCircuits = source.affectedCircuits;
            this.description = source.description;
            this.endTime = source.endTime;
            this.issueType = source.issueType;
            this.name = source.name;
            this.source = source.source;
            this.startTime = source.startTime;
            this.state = source.state;
        }

        public List<String> getAffectedCircuitsList() {
            return this.affectedCircuits;
        }

        public Builder addAllAffectedCircuits(List<String> affectedCircuits) {
            if (this.affectedCircuits == null) {
                this.affectedCircuits = new LinkedList<String>();
            }
            this.affectedCircuits.addAll(affectedCircuits);
            return this;
        }

        public Builder addAffectedCircuits(String affectedCircuits) {
            if (this.affectedCircuits == null) {
                this.affectedCircuits = new LinkedList<String>();
            }
            this.affectedCircuits.add(affectedCircuits);
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public Builder setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public String getIssueType() {
            return this.issueType;
        }

        public Builder setIssueType(String issueType) {
            this.issueType = issueType;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public Builder setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public String getState() {
            return this.state;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public InterconnectOutageNotification build() {
            return new InterconnectOutageNotification(this.affectedCircuits, this.description, this.endTime, this.issueType, this.name, this.source, this.startTime, this.state);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAffectedCircuits(this.affectedCircuits);
            newBuilder.setDescription(this.description);
            newBuilder.setEndTime(this.endTime);
            newBuilder.setIssueType(this.issueType);
            newBuilder.setName(this.name);
            newBuilder.setSource(this.source);
            newBuilder.setStartTime(this.startTime);
            newBuilder.setState(this.state);
            return newBuilder;
        }
    }
}

