/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListMachineTypesHttpRequest;
import com.google.cloud.compute.v1.GetMachineTypeHttpRequest;
import com.google.cloud.compute.v1.ListMachineTypesHttpRequest;
import com.google.cloud.compute.v1.MachineType;
import com.google.cloud.compute.v1.MachineTypeAggregatedList;
import com.google.cloud.compute.v1.MachineTypeList;
import com.google.cloud.compute.v1.MachineTypeSettings;
import com.google.cloud.compute.v1.MachineTypesScopedList;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneMachineTypeName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.stub.MachineTypeStub;
import com.google.cloud.compute.v1.stub.MachineTypeStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class MachineTypeClient
implements BackgroundResource {
    private final MachineTypeSettings settings;
    private final MachineTypeStub stub;

    public static final MachineTypeClient create() throws IOException {
        return MachineTypeClient.create(MachineTypeSettings.newBuilder().build());
    }

    public static final MachineTypeClient create(MachineTypeSettings settings) throws IOException {
        return new MachineTypeClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final MachineTypeClient create(MachineTypeStub stub) {
        return new MachineTypeClient(stub);
    }

    protected MachineTypeClient(MachineTypeSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MachineTypeStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected MachineTypeClient(MachineTypeStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MachineTypeSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MachineTypeStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListMachineTypesPagedResponse aggregatedListMachineTypes(ProjectName project) {
        AggregatedListMachineTypesHttpRequest request = AggregatedListMachineTypesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListMachineTypes(request);
    }

    @BetaApi
    public final AggregatedListMachineTypesPagedResponse aggregatedListMachineTypes(String project) {
        AggregatedListMachineTypesHttpRequest request = AggregatedListMachineTypesHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListMachineTypes(request);
    }

    @BetaApi
    public final AggregatedListMachineTypesPagedResponse aggregatedListMachineTypes(AggregatedListMachineTypesHttpRequest request) {
        return (AggregatedListMachineTypesPagedResponse)((Object)this.aggregatedListMachineTypesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListMachineTypesHttpRequest, AggregatedListMachineTypesPagedResponse> aggregatedListMachineTypesPagedCallable() {
        return this.stub.aggregatedListMachineTypesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList> aggregatedListMachineTypesCallable() {
        return this.stub.aggregatedListMachineTypesCallable();
    }

    @BetaApi
    public final MachineType getMachineType(ProjectZoneMachineTypeName machineType) {
        GetMachineTypeHttpRequest request = GetMachineTypeHttpRequest.newBuilder().setMachineType(machineType == null ? null : machineType.toString()).build();
        return this.getMachineType(request);
    }

    @BetaApi
    public final MachineType getMachineType(String machineType) {
        GetMachineTypeHttpRequest request = GetMachineTypeHttpRequest.newBuilder().setMachineType(machineType).build();
        return this.getMachineType(request);
    }

    @BetaApi
    public final MachineType getMachineType(GetMachineTypeHttpRequest request) {
        return (MachineType)this.getMachineTypeCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetMachineTypeHttpRequest, MachineType> getMachineTypeCallable() {
        return this.stub.getMachineTypeCallable();
    }

    @BetaApi
    public final ListMachineTypesPagedResponse listMachineTypes(ProjectZoneName zone) {
        ListMachineTypesHttpRequest request = ListMachineTypesHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listMachineTypes(request);
    }

    @BetaApi
    public final ListMachineTypesPagedResponse listMachineTypes(String zone) {
        ListMachineTypesHttpRequest request = ListMachineTypesHttpRequest.newBuilder().setZone(zone).build();
        return this.listMachineTypes(request);
    }

    @BetaApi
    public final ListMachineTypesPagedResponse listMachineTypes(ListMachineTypesHttpRequest request) {
        return (ListMachineTypesPagedResponse)((Object)this.listMachineTypesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListMachineTypesHttpRequest, ListMachineTypesPagedResponse> listMachineTypesPagedCallable() {
        return this.stub.listMachineTypesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListMachineTypesHttpRequest, MachineTypeList> listMachineTypesCallable() {
        return this.stub.listMachineTypesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListMachineTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMachineTypesHttpRequest, MachineTypeList, MachineType, ListMachineTypesPage, ListMachineTypesFixedSizeCollection> {
        private ListMachineTypesFixedSizeCollection(List<ListMachineTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMachineTypesFixedSizeCollection createEmptyCollection() {
            return new ListMachineTypesFixedSizeCollection(null, 0);
        }

        protected ListMachineTypesFixedSizeCollection createCollection(List<ListMachineTypesPage> pages, int collectionSize) {
            return new ListMachineTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMachineTypesPage
    extends AbstractPage<ListMachineTypesHttpRequest, MachineTypeList, MachineType, ListMachineTypesPage> {
        private ListMachineTypesPage(PageContext<ListMachineTypesHttpRequest, MachineTypeList, MachineType> context, MachineTypeList response) {
            super(context, (Object)response);
        }

        private static ListMachineTypesPage createEmptyPage() {
            return new ListMachineTypesPage(null, null);
        }

        protected ListMachineTypesPage createPage(PageContext<ListMachineTypesHttpRequest, MachineTypeList, MachineType> context, MachineTypeList response) {
            return new ListMachineTypesPage(context, response);
        }

        public ApiFuture<ListMachineTypesPage> createPageAsync(PageContext<ListMachineTypesHttpRequest, MachineTypeList, MachineType> context, ApiFuture<MachineTypeList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMachineTypesPagedResponse
    extends AbstractPagedListResponse<ListMachineTypesHttpRequest, MachineTypeList, MachineType, ListMachineTypesPage, ListMachineTypesFixedSizeCollection> {
        public static ApiFuture<ListMachineTypesPagedResponse> createAsync(PageContext<ListMachineTypesHttpRequest, MachineTypeList, MachineType> context, ApiFuture<MachineTypeList> futureResponse) {
            ApiFuture<ListMachineTypesPage> futurePage = ListMachineTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListMachineTypesPage, ListMachineTypesPagedResponse>(){

                public ListMachineTypesPagedResponse apply(ListMachineTypesPage input) {
                    return new ListMachineTypesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListMachineTypesPagedResponse(ListMachineTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMachineTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListMachineTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypesScopedList, AggregatedListMachineTypesPage, AggregatedListMachineTypesFixedSizeCollection> {
        private AggregatedListMachineTypesFixedSizeCollection(List<AggregatedListMachineTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListMachineTypesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListMachineTypesFixedSizeCollection(null, 0);
        }

        protected AggregatedListMachineTypesFixedSizeCollection createCollection(List<AggregatedListMachineTypesPage> pages, int collectionSize) {
            return new AggregatedListMachineTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListMachineTypesPage
    extends AbstractPage<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypesScopedList, AggregatedListMachineTypesPage> {
        private AggregatedListMachineTypesPage(PageContext<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypesScopedList> context, MachineTypeAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListMachineTypesPage createEmptyPage() {
            return new AggregatedListMachineTypesPage(null, null);
        }

        protected AggregatedListMachineTypesPage createPage(PageContext<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypesScopedList> context, MachineTypeAggregatedList response) {
            return new AggregatedListMachineTypesPage(context, response);
        }

        public ApiFuture<AggregatedListMachineTypesPage> createPageAsync(PageContext<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypesScopedList> context, ApiFuture<MachineTypeAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListMachineTypesPagedResponse
    extends AbstractPagedListResponse<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypesScopedList, AggregatedListMachineTypesPage, AggregatedListMachineTypesFixedSizeCollection> {
        public static ApiFuture<AggregatedListMachineTypesPagedResponse> createAsync(PageContext<AggregatedListMachineTypesHttpRequest, MachineTypeAggregatedList, MachineTypesScopedList> context, ApiFuture<MachineTypeAggregatedList> futureResponse) {
            ApiFuture<AggregatedListMachineTypesPage> futurePage = AggregatedListMachineTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListMachineTypesPage, AggregatedListMachineTypesPagedResponse>(){

                public AggregatedListMachineTypesPagedResponse apply(AggregatedListMachineTypesPage input) {
                    return new AggregatedListMachineTypesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListMachineTypesPagedResponse(AggregatedListMachineTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListMachineTypesFixedSizeCollection.createEmptyCollection());
        }
    }
}

