/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.ManagedInstanceLastAttempt;
import com.google.cloud.compute.v1.ManagedInstanceVersion;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ManagedInstance
implements ApiMessage {
    private final String currentAction;
    private final String id;
    private final String instance;
    private final String instanceStatus;
    private final ManagedInstanceLastAttempt lastAttempt;
    private final ManagedInstanceVersion version;
    private static final ManagedInstance DEFAULT_INSTANCE = new ManagedInstance();

    private ManagedInstance() {
        this.currentAction = null;
        this.id = null;
        this.instance = null;
        this.instanceStatus = null;
        this.lastAttempt = null;
        this.version = null;
    }

    private ManagedInstance(String currentAction, String id, String instance, String instanceStatus, ManagedInstanceLastAttempt lastAttempt, ManagedInstanceVersion version) {
        this.currentAction = currentAction;
        this.id = id;
        this.instance = instance;
        this.instanceStatus = instanceStatus;
        this.lastAttempt = lastAttempt;
        this.version = version;
    }

    public Object getFieldValue(String fieldName) {
        if ("currentAction".equals(fieldName)) {
            return this.currentAction;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("instance".equals(fieldName)) {
            return this.instance;
        }
        if ("instanceStatus".equals(fieldName)) {
            return this.instanceStatus;
        }
        if ("lastAttempt".equals(fieldName)) {
            return this.lastAttempt;
        }
        if ("version".equals(fieldName)) {
            return this.version;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCurrentAction() {
        return this.currentAction;
    }

    public String getId() {
        return this.id;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getInstanceStatus() {
        return this.instanceStatus;
    }

    public ManagedInstanceLastAttempt getLastAttempt() {
        return this.lastAttempt;
    }

    public ManagedInstanceVersion getVersion() {
        return this.version;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ManagedInstance prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ManagedInstance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ManagedInstance{currentAction=" + this.currentAction + ", id=" + this.id + ", instance=" + this.instance + ", instanceStatus=" + this.instanceStatus + ", lastAttempt=" + this.lastAttempt + ", version=" + this.version + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ManagedInstance) {
            ManagedInstance that = (ManagedInstance)o;
            return Objects.equals(this.currentAction, that.getCurrentAction()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.instance, that.getInstance()) && Objects.equals(this.instanceStatus, that.getInstanceStatus()) && Objects.equals(this.lastAttempt, that.getLastAttempt()) && Objects.equals(this.version, that.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.currentAction, this.id, this.instance, this.instanceStatus, this.lastAttempt, this.version);
    }

    public static class Builder {
        private String currentAction;
        private String id;
        private String instance;
        private String instanceStatus;
        private ManagedInstanceLastAttempt lastAttempt;
        private ManagedInstanceVersion version;

        Builder() {
        }

        public Builder mergeFrom(ManagedInstance other) {
            if (other == ManagedInstance.getDefaultInstance()) {
                return this;
            }
            if (other.getCurrentAction() != null) {
                this.currentAction = other.currentAction;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getInstance() != null) {
                this.instance = other.instance;
            }
            if (other.getInstanceStatus() != null) {
                this.instanceStatus = other.instanceStatus;
            }
            if (other.getLastAttempt() != null) {
                this.lastAttempt = other.lastAttempt;
            }
            if (other.getVersion() != null) {
                this.version = other.version;
            }
            return this;
        }

        Builder(ManagedInstance source) {
            this.currentAction = source.currentAction;
            this.id = source.id;
            this.instance = source.instance;
            this.instanceStatus = source.instanceStatus;
            this.lastAttempt = source.lastAttempt;
            this.version = source.version;
        }

        public String getCurrentAction() {
            return this.currentAction;
        }

        public Builder setCurrentAction(String currentAction) {
            this.currentAction = currentAction;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public String getInstanceStatus() {
            return this.instanceStatus;
        }

        public Builder setInstanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public ManagedInstanceLastAttempt getLastAttempt() {
            return this.lastAttempt;
        }

        public Builder setLastAttempt(ManagedInstanceLastAttempt lastAttempt) {
            this.lastAttempt = lastAttempt;
            return this;
        }

        public ManagedInstanceVersion getVersion() {
            return this.version;
        }

        public Builder setVersion(ManagedInstanceVersion version) {
            this.version = version;
            return this;
        }

        public ManagedInstance build() {
            return new ManagedInstance(this.currentAction, this.id, this.instance, this.instanceStatus, this.lastAttempt, this.version);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCurrentAction(this.currentAction);
            newBuilder.setId(this.id);
            newBuilder.setInstance(this.instance);
            newBuilder.setInstanceStatus(this.instanceStatus);
            newBuilder.setLastAttempt(this.lastAttempt);
            newBuilder.setVersion(this.version);
            return newBuilder;
        }
    }
}

