/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.NodeType;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NodeTypesScopedList
implements ApiMessage {
    private final List<NodeType> nodeTypes;
    private final Warning warning;
    private static final NodeTypesScopedList DEFAULT_INSTANCE = new NodeTypesScopedList();

    private NodeTypesScopedList() {
        this.nodeTypes = null;
        this.warning = null;
    }

    private NodeTypesScopedList(List<NodeType> nodeTypes, Warning warning) {
        this.nodeTypes = nodeTypes;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("nodeTypes".equals(fieldName)) {
            return this.nodeTypes;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<NodeType> getNodeTypesList() {
        return this.nodeTypes;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NodeTypesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NodeTypesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NodeTypesScopedList{nodeTypes=" + this.nodeTypes + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NodeTypesScopedList) {
            NodeTypesScopedList that = (NodeTypesScopedList)o;
            return Objects.equals(this.nodeTypes, that.getNodeTypesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.nodeTypes, this.warning);
    }

    public static class Builder {
        private List<NodeType> nodeTypes;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(NodeTypesScopedList other) {
            if (other == NodeTypesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getNodeTypesList() != null) {
                this.nodeTypes = other.nodeTypes;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(NodeTypesScopedList source) {
            this.nodeTypes = source.nodeTypes;
            this.warning = source.warning;
        }

        public List<NodeType> getNodeTypesList() {
            return this.nodeTypes;
        }

        public Builder addAllNodeTypes(List<NodeType> nodeTypes) {
            if (this.nodeTypes == null) {
                this.nodeTypes = new LinkedList<NodeType>();
            }
            this.nodeTypes.addAll(nodeTypes);
            return this;
        }

        public Builder addNodeTypes(NodeType nodeTypes) {
            if (this.nodeTypes == null) {
                this.nodeTypes = new LinkedList<NodeType>();
            }
            this.nodeTypes.add(nodeTypes);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public NodeTypesScopedList build() {
            return new NodeTypesScopedList(this.nodeTypes, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllNodeTypes(this.nodeTypes);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

