/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Error;
import com.google.cloud.compute.v1.Warnings;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Operation
implements ApiMessage {
    private final String clientOperationId;
    private final String creationTimestamp;
    private final String description;
    private final String endTime;
    private final Error error;
    private final String httpErrorMessage;
    private final Integer httpErrorStatusCode;
    private final String id;
    private final String insertTime;
    private final String kind;
    private final String name;
    private final String operationType;
    private final Integer progress;
    private final String region;
    private final String selfLink;
    private final String startTime;
    private final String status;
    private final String statusMessage;
    private final String targetId;
    private final String targetLink;
    private final String user;
    private final List<Warnings> warnings;
    private final String zone;
    private static final Operation DEFAULT_INSTANCE = new Operation();

    private Operation() {
        this.clientOperationId = null;
        this.creationTimestamp = null;
        this.description = null;
        this.endTime = null;
        this.error = null;
        this.httpErrorMessage = null;
        this.httpErrorStatusCode = null;
        this.id = null;
        this.insertTime = null;
        this.kind = null;
        this.name = null;
        this.operationType = null;
        this.progress = null;
        this.region = null;
        this.selfLink = null;
        this.startTime = null;
        this.status = null;
        this.statusMessage = null;
        this.targetId = null;
        this.targetLink = null;
        this.user = null;
        this.warnings = null;
        this.zone = null;
    }

    private Operation(String clientOperationId, String creationTimestamp, String description, String endTime, Error error, String httpErrorMessage, Integer httpErrorStatusCode, String id, String insertTime, String kind, String name, String operationType, Integer progress, String region, String selfLink, String startTime, String status, String statusMessage, String targetId, String targetLink, String user, List<Warnings> warnings, String zone) {
        this.clientOperationId = clientOperationId;
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.endTime = endTime;
        this.error = error;
        this.httpErrorMessage = httpErrorMessage;
        this.httpErrorStatusCode = httpErrorStatusCode;
        this.id = id;
        this.insertTime = insertTime;
        this.kind = kind;
        this.name = name;
        this.operationType = operationType;
        this.progress = progress;
        this.region = region;
        this.selfLink = selfLink;
        this.startTime = startTime;
        this.status = status;
        this.statusMessage = statusMessage;
        this.targetId = targetId;
        this.targetLink = targetLink;
        this.user = user;
        this.warnings = warnings;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if ("clientOperationId".equals(fieldName)) {
            return this.clientOperationId;
        }
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("endTime".equals(fieldName)) {
            return this.endTime;
        }
        if ("error".equals(fieldName)) {
            return this.error;
        }
        if ("httpErrorMessage".equals(fieldName)) {
            return this.httpErrorMessage;
        }
        if ("httpErrorStatusCode".equals(fieldName)) {
            return this.httpErrorStatusCode;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("insertTime".equals(fieldName)) {
            return this.insertTime;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("operationType".equals(fieldName)) {
            return this.operationType;
        }
        if ("progress".equals(fieldName)) {
            return this.progress;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("startTime".equals(fieldName)) {
            return this.startTime;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        if ("statusMessage".equals(fieldName)) {
            return this.statusMessage;
        }
        if ("targetId".equals(fieldName)) {
            return this.targetId;
        }
        if ("targetLink".equals(fieldName)) {
            return this.targetLink;
        }
        if ("user".equals(fieldName)) {
            return this.user;
        }
        if ("warnings".equals(fieldName)) {
            return this.warnings;
        }
        if ("zone".equals(fieldName)) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getClientOperationId() {
        return this.clientOperationId;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Error getError() {
        return this.error;
    }

    public String getHttpErrorMessage() {
        return this.httpErrorMessage;
    }

    public Integer getHttpErrorStatusCode() {
        return this.httpErrorStatusCode;
    }

    public String getId() {
        return this.id;
    }

    public String getInsertTime() {
        return this.insertTime;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetLink() {
        return this.targetLink;
    }

    public String getUser() {
        return this.user;
    }

    public List<Warnings> getWarningsList() {
        return this.warnings;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Operation prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Operation getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Operation{clientOperationId=" + this.clientOperationId + ", creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", endTime=" + this.endTime + ", error=" + this.error + ", httpErrorMessage=" + this.httpErrorMessage + ", httpErrorStatusCode=" + this.httpErrorStatusCode + ", id=" + this.id + ", insertTime=" + this.insertTime + ", kind=" + this.kind + ", name=" + this.name + ", operationType=" + this.operationType + ", progress=" + this.progress + ", region=" + this.region + ", selfLink=" + this.selfLink + ", startTime=" + this.startTime + ", status=" + this.status + ", statusMessage=" + this.statusMessage + ", targetId=" + this.targetId + ", targetLink=" + this.targetLink + ", user=" + this.user + ", warnings=" + this.warnings + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Operation) {
            Operation that = (Operation)o;
            return Objects.equals(this.clientOperationId, that.getClientOperationId()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.endTime, that.getEndTime()) && Objects.equals(this.error, that.getError()) && Objects.equals(this.httpErrorMessage, that.getHttpErrorMessage()) && Objects.equals(this.httpErrorStatusCode, that.getHttpErrorStatusCode()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.insertTime, that.getInsertTime()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.operationType, that.getOperationType()) && Objects.equals(this.progress, that.getProgress()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.startTime, that.getStartTime()) && Objects.equals(this.status, that.getStatus()) && Objects.equals(this.statusMessage, that.getStatusMessage()) && Objects.equals(this.targetId, that.getTargetId()) && Objects.equals(this.targetLink, that.getTargetLink()) && Objects.equals(this.user, that.getUser()) && Objects.equals(this.warnings, that.getWarningsList()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.clientOperationId, this.creationTimestamp, this.description, this.endTime, this.error, this.httpErrorMessage, this.httpErrorStatusCode, this.id, this.insertTime, this.kind, this.name, this.operationType, this.progress, this.region, this.selfLink, this.startTime, this.status, this.statusMessage, this.targetId, this.targetLink, this.user, this.warnings, this.zone);
    }

    public static class Builder {
        private String clientOperationId;
        private String creationTimestamp;
        private String description;
        private String endTime;
        private Error error;
        private String httpErrorMessage;
        private Integer httpErrorStatusCode;
        private String id;
        private String insertTime;
        private String kind;
        private String name;
        private String operationType;
        private Integer progress;
        private String region;
        private String selfLink;
        private String startTime;
        private String status;
        private String statusMessage;
        private String targetId;
        private String targetLink;
        private String user;
        private List<Warnings> warnings;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(Operation other) {
            if (other == Operation.getDefaultInstance()) {
                return this;
            }
            if (other.getClientOperationId() != null) {
                this.clientOperationId = other.clientOperationId;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getEndTime() != null) {
                this.endTime = other.endTime;
            }
            if (other.getError() != null) {
                this.error = other.error;
            }
            if (other.getHttpErrorMessage() != null) {
                this.httpErrorMessage = other.httpErrorMessage;
            }
            if (other.getHttpErrorStatusCode() != null) {
                this.httpErrorStatusCode = other.httpErrorStatusCode;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getInsertTime() != null) {
                this.insertTime = other.insertTime;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getOperationType() != null) {
                this.operationType = other.operationType;
            }
            if (other.getProgress() != null) {
                this.progress = other.progress;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getStartTime() != null) {
                this.startTime = other.startTime;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            if (other.getStatusMessage() != null) {
                this.statusMessage = other.statusMessage;
            }
            if (other.getTargetId() != null) {
                this.targetId = other.targetId;
            }
            if (other.getTargetLink() != null) {
                this.targetLink = other.targetLink;
            }
            if (other.getUser() != null) {
                this.user = other.user;
            }
            if (other.getWarningsList() != null) {
                this.warnings = other.warnings;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(Operation source) {
            this.clientOperationId = source.clientOperationId;
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.endTime = source.endTime;
            this.error = source.error;
            this.httpErrorMessage = source.httpErrorMessage;
            this.httpErrorStatusCode = source.httpErrorStatusCode;
            this.id = source.id;
            this.insertTime = source.insertTime;
            this.kind = source.kind;
            this.name = source.name;
            this.operationType = source.operationType;
            this.progress = source.progress;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.startTime = source.startTime;
            this.status = source.status;
            this.statusMessage = source.statusMessage;
            this.targetId = source.targetId;
            this.targetLink = source.targetLink;
            this.user = source.user;
            this.warnings = source.warnings;
            this.zone = source.zone;
        }

        public String getClientOperationId() {
            return this.clientOperationId;
        }

        public Builder setClientOperationId(String clientOperationId) {
            this.clientOperationId = clientOperationId;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public Builder setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Error getError() {
            return this.error;
        }

        public Builder setError(Error error) {
            this.error = error;
            return this;
        }

        public String getHttpErrorMessage() {
            return this.httpErrorMessage;
        }

        public Builder setHttpErrorMessage(String httpErrorMessage) {
            this.httpErrorMessage = httpErrorMessage;
            return this;
        }

        public Integer getHttpErrorStatusCode() {
            return this.httpErrorStatusCode;
        }

        public Builder setHttpErrorStatusCode(Integer httpErrorStatusCode) {
            this.httpErrorStatusCode = httpErrorStatusCode;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getInsertTime() {
            return this.insertTime;
        }

        public Builder setInsertTime(String insertTime) {
            this.insertTime = insertTime;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getOperationType() {
            return this.operationType;
        }

        public Builder setOperationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public Integer getProgress() {
            return this.progress;
        }

        public Builder setProgress(Integer progress) {
            this.progress = progress;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public Builder setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public Builder setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public Builder setTargetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public String getTargetLink() {
            return this.targetLink;
        }

        public Builder setTargetLink(String targetLink) {
            this.targetLink = targetLink;
            return this;
        }

        public String getUser() {
            return this.user;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public List<Warnings> getWarningsList() {
            return this.warnings;
        }

        public Builder addAllWarnings(List<Warnings> warnings) {
            if (this.warnings == null) {
                this.warnings = new LinkedList<Warnings>();
            }
            this.warnings.addAll(warnings);
            return this;
        }

        public Builder addWarnings(Warnings warnings) {
            if (this.warnings == null) {
                this.warnings = new LinkedList<Warnings>();
            }
            this.warnings.add(warnings);
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Operation build() {
            return new Operation(this.clientOperationId, this.creationTimestamp, this.description, this.endTime, this.error, this.httpErrorMessage, this.httpErrorStatusCode, this.id, this.insertTime, this.kind, this.name, this.operationType, this.progress, this.region, this.selfLink, this.startTime, this.status, this.statusMessage, this.targetId, this.targetLink, this.user, this.warnings, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setClientOperationId(this.clientOperationId);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setEndTime(this.endTime);
            newBuilder.setError(this.error);
            newBuilder.setHttpErrorMessage(this.httpErrorMessage);
            newBuilder.setHttpErrorStatusCode(this.httpErrorStatusCode);
            newBuilder.setId(this.id);
            newBuilder.setInsertTime(this.insertTime);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setOperationType(this.operationType);
            newBuilder.setProgress(this.progress);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setStartTime(this.startTime);
            newBuilder.setStatus(this.status);
            newBuilder.setStatusMessage(this.statusMessage);
            newBuilder.setTargetId(this.targetId);
            newBuilder.setTargetLink(this.targetLink);
            newBuilder.setUser(this.user);
            newBuilder.addAllWarnings(this.warnings);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

