/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetRegionInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.InstanceWithNamedPorts;
import com.google.cloud.compute.v1.ListInstancesRegionInstanceGroupsHttpRequest;
import com.google.cloud.compute.v1.ListRegionInstanceGroupsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectRegionInstanceGroupName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.RegionInstanceGroupList;
import com.google.cloud.compute.v1.RegionInstanceGroupSettings;
import com.google.cloud.compute.v1.RegionInstanceGroupsListInstances;
import com.google.cloud.compute.v1.RegionInstanceGroupsListInstancesRequest;
import com.google.cloud.compute.v1.RegionInstanceGroupsSetNamedPortsRequest;
import com.google.cloud.compute.v1.SetNamedPortsRegionInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.stub.RegionInstanceGroupStub;
import com.google.cloud.compute.v1.stub.RegionInstanceGroupStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionInstanceGroupClient
implements BackgroundResource {
    private final RegionInstanceGroupSettings settings;
    private final RegionInstanceGroupStub stub;

    public static final RegionInstanceGroupClient create() throws IOException {
        return RegionInstanceGroupClient.create(RegionInstanceGroupSettings.newBuilder().build());
    }

    public static final RegionInstanceGroupClient create(RegionInstanceGroupSettings settings) throws IOException {
        return new RegionInstanceGroupClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionInstanceGroupClient create(RegionInstanceGroupStub stub) {
        return new RegionInstanceGroupClient(stub);
    }

    protected RegionInstanceGroupClient(RegionInstanceGroupSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionInstanceGroupStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionInstanceGroupClient(RegionInstanceGroupStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionInstanceGroupSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionInstanceGroupStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final InstanceGroup getRegionInstanceGroup(ProjectRegionInstanceGroupName instanceGroup) {
        GetRegionInstanceGroupHttpRequest request = GetRegionInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup == null ? null : instanceGroup.toString()).build();
        return this.getRegionInstanceGroup(request);
    }

    @BetaApi
    public final InstanceGroup getRegionInstanceGroup(String instanceGroup) {
        GetRegionInstanceGroupHttpRequest request = GetRegionInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup).build();
        return this.getRegionInstanceGroup(request);
    }

    @BetaApi
    public final InstanceGroup getRegionInstanceGroup(GetRegionInstanceGroupHttpRequest request) {
        return (InstanceGroup)this.getRegionInstanceGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionInstanceGroupHttpRequest, InstanceGroup> getRegionInstanceGroupCallable() {
        return this.stub.getRegionInstanceGroupCallable();
    }

    @BetaApi
    public final ListRegionInstanceGroupsPagedResponse listRegionInstanceGroups(ProjectRegionName region) {
        ListRegionInstanceGroupsHttpRequest request = ListRegionInstanceGroupsHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionInstanceGroups(request);
    }

    @BetaApi
    public final ListRegionInstanceGroupsPagedResponse listRegionInstanceGroups(String region) {
        ListRegionInstanceGroupsHttpRequest request = ListRegionInstanceGroupsHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionInstanceGroups(request);
    }

    @BetaApi
    public final ListRegionInstanceGroupsPagedResponse listRegionInstanceGroups(ListRegionInstanceGroupsHttpRequest request) {
        return (ListRegionInstanceGroupsPagedResponse)((Object)this.listRegionInstanceGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionInstanceGroupsHttpRequest, ListRegionInstanceGroupsPagedResponse> listRegionInstanceGroupsPagedCallable() {
        return this.stub.listRegionInstanceGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList> listRegionInstanceGroupsCallable() {
        return this.stub.listRegionInstanceGroupsCallable();
    }

    @BetaApi
    public final ListInstancesRegionInstanceGroupsPagedResponse listInstancesRegionInstanceGroups(ProjectRegionInstanceGroupName instanceGroup, RegionInstanceGroupsListInstancesRequest regionInstanceGroupsListInstancesRequestResource) {
        ListInstancesRegionInstanceGroupsHttpRequest request = ListInstancesRegionInstanceGroupsHttpRequest.newBuilder().setInstanceGroup(instanceGroup == null ? null : instanceGroup.toString()).setRegionInstanceGroupsListInstancesRequestResource(regionInstanceGroupsListInstancesRequestResource).build();
        return this.listInstancesRegionInstanceGroups(request);
    }

    @BetaApi
    public final ListInstancesRegionInstanceGroupsPagedResponse listInstancesRegionInstanceGroups(String instanceGroup, RegionInstanceGroupsListInstancesRequest regionInstanceGroupsListInstancesRequestResource) {
        ListInstancesRegionInstanceGroupsHttpRequest request = ListInstancesRegionInstanceGroupsHttpRequest.newBuilder().setInstanceGroup(instanceGroup).setRegionInstanceGroupsListInstancesRequestResource(regionInstanceGroupsListInstancesRequestResource).build();
        return this.listInstancesRegionInstanceGroups(request);
    }

    @BetaApi
    public final ListInstancesRegionInstanceGroupsPagedResponse listInstancesRegionInstanceGroups(ListInstancesRegionInstanceGroupsHttpRequest request) {
        return (ListInstancesRegionInstanceGroupsPagedResponse)((Object)this.listInstancesRegionInstanceGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListInstancesRegionInstanceGroupsHttpRequest, ListInstancesRegionInstanceGroupsPagedResponse> listInstancesRegionInstanceGroupsPagedCallable() {
        return this.stub.listInstancesRegionInstanceGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances> listInstancesRegionInstanceGroupsCallable() {
        return this.stub.listInstancesRegionInstanceGroupsCallable();
    }

    @BetaApi
    public final Operation setNamedPortsRegionInstanceGroup(ProjectRegionInstanceGroupName instanceGroup, RegionInstanceGroupsSetNamedPortsRequest regionInstanceGroupsSetNamedPortsRequestResource) {
        SetNamedPortsRegionInstanceGroupHttpRequest request = SetNamedPortsRegionInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup == null ? null : instanceGroup.toString()).setRegionInstanceGroupsSetNamedPortsRequestResource(regionInstanceGroupsSetNamedPortsRequestResource).build();
        return this.setNamedPortsRegionInstanceGroup(request);
    }

    @BetaApi
    public final Operation setNamedPortsRegionInstanceGroup(String instanceGroup, RegionInstanceGroupsSetNamedPortsRequest regionInstanceGroupsSetNamedPortsRequestResource) {
        SetNamedPortsRegionInstanceGroupHttpRequest request = SetNamedPortsRegionInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup).setRegionInstanceGroupsSetNamedPortsRequestResource(regionInstanceGroupsSetNamedPortsRequestResource).build();
        return this.setNamedPortsRegionInstanceGroup(request);
    }

    @BetaApi
    public final Operation setNamedPortsRegionInstanceGroup(SetNamedPortsRegionInstanceGroupHttpRequest request) {
        return (Operation)this.setNamedPortsRegionInstanceGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetNamedPortsRegionInstanceGroupHttpRequest, Operation> setNamedPortsRegionInstanceGroupCallable() {
        return this.stub.setNamedPortsRegionInstanceGroupCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInstancesRegionInstanceGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesRegionInstanceGroupsPage, ListInstancesRegionInstanceGroupsFixedSizeCollection> {
        private ListInstancesRegionInstanceGroupsFixedSizeCollection(List<ListInstancesRegionInstanceGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesRegionInstanceGroupsFixedSizeCollection createEmptyCollection() {
            return new ListInstancesRegionInstanceGroupsFixedSizeCollection(null, 0);
        }

        protected ListInstancesRegionInstanceGroupsFixedSizeCollection createCollection(List<ListInstancesRegionInstanceGroupsPage> pages, int collectionSize) {
            return new ListInstancesRegionInstanceGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesRegionInstanceGroupsPage
    extends AbstractPage<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesRegionInstanceGroupsPage> {
        private ListInstancesRegionInstanceGroupsPage(PageContext<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts> context, RegionInstanceGroupsListInstances response) {
            super(context, (Object)response);
        }

        private static ListInstancesRegionInstanceGroupsPage createEmptyPage() {
            return new ListInstancesRegionInstanceGroupsPage(null, null);
        }

        protected ListInstancesRegionInstanceGroupsPage createPage(PageContext<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts> context, RegionInstanceGroupsListInstances response) {
            return new ListInstancesRegionInstanceGroupsPage(context, response);
        }

        public ApiFuture<ListInstancesRegionInstanceGroupsPage> createPageAsync(PageContext<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts> context, ApiFuture<RegionInstanceGroupsListInstances> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesRegionInstanceGroupsPagedResponse
    extends AbstractPagedListResponse<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesRegionInstanceGroupsPage, ListInstancesRegionInstanceGroupsFixedSizeCollection> {
        public static ApiFuture<ListInstancesRegionInstanceGroupsPagedResponse> createAsync(PageContext<ListInstancesRegionInstanceGroupsHttpRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts> context, ApiFuture<RegionInstanceGroupsListInstances> futureResponse) {
            ApiFuture<ListInstancesRegionInstanceGroupsPage> futurePage = ListInstancesRegionInstanceGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstancesRegionInstanceGroupsPage, ListInstancesRegionInstanceGroupsPagedResponse>(){

                public ListInstancesRegionInstanceGroupsPagedResponse apply(ListInstancesRegionInstanceGroupsPage input) {
                    return new ListInstancesRegionInstanceGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesRegionInstanceGroupsPagedResponse(ListInstancesRegionInstanceGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesRegionInstanceGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRegionInstanceGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, InstanceGroup, ListRegionInstanceGroupsPage, ListRegionInstanceGroupsFixedSizeCollection> {
        private ListRegionInstanceGroupsFixedSizeCollection(List<ListRegionInstanceGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionInstanceGroupsFixedSizeCollection createEmptyCollection() {
            return new ListRegionInstanceGroupsFixedSizeCollection(null, 0);
        }

        protected ListRegionInstanceGroupsFixedSizeCollection createCollection(List<ListRegionInstanceGroupsPage> pages, int collectionSize) {
            return new ListRegionInstanceGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionInstanceGroupsPage
    extends AbstractPage<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, InstanceGroup, ListRegionInstanceGroupsPage> {
        private ListRegionInstanceGroupsPage(PageContext<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, InstanceGroup> context, RegionInstanceGroupList response) {
            super(context, (Object)response);
        }

        private static ListRegionInstanceGroupsPage createEmptyPage() {
            return new ListRegionInstanceGroupsPage(null, null);
        }

        protected ListRegionInstanceGroupsPage createPage(PageContext<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, InstanceGroup> context, RegionInstanceGroupList response) {
            return new ListRegionInstanceGroupsPage(context, response);
        }

        public ApiFuture<ListRegionInstanceGroupsPage> createPageAsync(PageContext<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, InstanceGroup> context, ApiFuture<RegionInstanceGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionInstanceGroupsPagedResponse
    extends AbstractPagedListResponse<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, InstanceGroup, ListRegionInstanceGroupsPage, ListRegionInstanceGroupsFixedSizeCollection> {
        public static ApiFuture<ListRegionInstanceGroupsPagedResponse> createAsync(PageContext<ListRegionInstanceGroupsHttpRequest, RegionInstanceGroupList, InstanceGroup> context, ApiFuture<RegionInstanceGroupList> futureResponse) {
            ApiFuture<ListRegionInstanceGroupsPage> futurePage = ListRegionInstanceGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionInstanceGroupsPage, ListRegionInstanceGroupsPagedResponse>(){

                public ListRegionInstanceGroupsPagedResponse apply(ListRegionInstanceGroupsPage input) {
                    return new ListRegionInstanceGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionInstanceGroupsPagedResponse(ListRegionInstanceGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionInstanceGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

