/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SecurityPolicyList
implements ApiMessage {
    private final String id;
    private final List<SecurityPolicy> items;
    private final String kind;
    private final String nextPageToken;
    private final Warning warning;
    private static final SecurityPolicyList DEFAULT_INSTANCE = new SecurityPolicyList();

    private SecurityPolicyList() {
        this.id = null;
        this.items = null;
        this.kind = null;
        this.nextPageToken = null;
        this.warning = null;
    }

    private SecurityPolicyList(String id, List<SecurityPolicy> items, String kind, String nextPageToken, Warning warning) {
        this.id = id;
        this.items = items;
        this.kind = kind;
        this.nextPageToken = nextPageToken;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("items".equals(fieldName)) {
            return this.items;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("nextPageToken".equals(fieldName)) {
            return this.nextPageToken;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public List<SecurityPolicy> getItemsList() {
        return this.items;
    }

    public String getKind() {
        return this.kind;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SecurityPolicyList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SecurityPolicyList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SecurityPolicyList{id=" + this.id + ", items=" + this.items + ", kind=" + this.kind + ", nextPageToken=" + this.nextPageToken + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SecurityPolicyList) {
            SecurityPolicyList that = (SecurityPolicyList)o;
            return Objects.equals(this.id, that.getId()) && Objects.equals(this.items, that.getItemsList()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.nextPageToken, that.getNextPageToken()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.items, this.kind, this.nextPageToken, this.warning);
    }

    public static class Builder {
        private String id;
        private List<SecurityPolicy> items;
        private String kind;
        private String nextPageToken;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(SecurityPolicyList other) {
            if (other == SecurityPolicyList.getDefaultInstance()) {
                return this;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getItemsList() != null) {
                this.items = other.items;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getNextPageToken() != null) {
                this.nextPageToken = other.nextPageToken;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(SecurityPolicyList source) {
            this.id = source.id;
            this.items = source.items;
            this.kind = source.kind;
            this.nextPageToken = source.nextPageToken;
            this.warning = source.warning;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public List<SecurityPolicy> getItemsList() {
            return this.items;
        }

        public Builder addAllItems(List<SecurityPolicy> items) {
            if (this.items == null) {
                this.items = new LinkedList<SecurityPolicy>();
            }
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(SecurityPolicy items) {
            if (this.items == null) {
                this.items = new LinkedList<SecurityPolicy>();
            }
            this.items.add(items);
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public SecurityPolicyList build() {
            return new SecurityPolicyList(this.id, this.items, this.kind, this.nextPageToken, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setId(this.id);
            newBuilder.addAllItems(this.items);
            newBuilder.setKind(this.kind);
            newBuilder.setNextPageToken(this.nextPageToken);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

