/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.DeprecationStatus;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Zone
implements ApiMessage {
    private final List<String> availableCpuPlatforms;
    private final String creationTimestamp;
    private final DeprecationStatus deprecated;
    private final String description;
    private final String id;
    private final String kind;
    private final String name;
    private final String region;
    private final String selfLink;
    private final String status;
    private static final Zone DEFAULT_INSTANCE = new Zone();

    private Zone() {
        this.availableCpuPlatforms = null;
        this.creationTimestamp = null;
        this.deprecated = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.region = null;
        this.selfLink = null;
        this.status = null;
    }

    private Zone(List<String> availableCpuPlatforms, String creationTimestamp, DeprecationStatus deprecated, String description, String id, String kind, String name, String region, String selfLink, String status) {
        this.availableCpuPlatforms = availableCpuPlatforms;
        this.creationTimestamp = creationTimestamp;
        this.deprecated = deprecated;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.region = region;
        this.selfLink = selfLink;
        this.status = status;
    }

    public Object getFieldValue(String fieldName) {
        if ("availableCpuPlatforms".equals(fieldName)) {
            return this.availableCpuPlatforms;
        }
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("deprecated".equals(fieldName)) {
            return this.deprecated;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getAvailableCpuPlatformsList() {
        return this.availableCpuPlatforms;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public DeprecationStatus getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getStatus() {
        return this.status;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Zone prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Zone getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Zone{availableCpuPlatforms=" + this.availableCpuPlatforms + ", creationTimestamp=" + this.creationTimestamp + ", deprecated=" + this.deprecated + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", region=" + this.region + ", selfLink=" + this.selfLink + ", status=" + this.status + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Zone) {
            Zone that = (Zone)o;
            return Objects.equals(this.availableCpuPlatforms, that.getAvailableCpuPlatformsList()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.deprecated, that.getDeprecated()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.status, that.getStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.availableCpuPlatforms, this.creationTimestamp, this.deprecated, this.description, this.id, this.kind, this.name, this.region, this.selfLink, this.status);
    }

    public static class Builder {
        private List<String> availableCpuPlatforms;
        private String creationTimestamp;
        private DeprecationStatus deprecated;
        private String description;
        private String id;
        private String kind;
        private String name;
        private String region;
        private String selfLink;
        private String status;

        Builder() {
        }

        public Builder mergeFrom(Zone other) {
            if (other == Zone.getDefaultInstance()) {
                return this;
            }
            if (other.getAvailableCpuPlatformsList() != null) {
                this.availableCpuPlatforms = other.availableCpuPlatforms;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDeprecated() != null) {
                this.deprecated = other.deprecated;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            return this;
        }

        Builder(Zone source) {
            this.availableCpuPlatforms = source.availableCpuPlatforms;
            this.creationTimestamp = source.creationTimestamp;
            this.deprecated = source.deprecated;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.status = source.status;
        }

        public List<String> getAvailableCpuPlatformsList() {
            return this.availableCpuPlatforms;
        }

        public Builder addAllAvailableCpuPlatforms(List<String> availableCpuPlatforms) {
            if (this.availableCpuPlatforms == null) {
                this.availableCpuPlatforms = new LinkedList<String>();
            }
            this.availableCpuPlatforms.addAll(availableCpuPlatforms);
            return this;
        }

        public Builder addAvailableCpuPlatforms(String availableCpuPlatforms) {
            if (this.availableCpuPlatforms == null) {
                this.availableCpuPlatforms = new LinkedList<String>();
            }
            this.availableCpuPlatforms.add(availableCpuPlatforms);
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public DeprecationStatus getDeprecated() {
            return this.deprecated;
        }

        public Builder setDeprecated(DeprecationStatus deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public Zone build() {
            return new Zone(this.availableCpuPlatforms, this.creationTimestamp, this.deprecated, this.description, this.id, this.kind, this.name, this.region, this.selfLink, this.status);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAvailableCpuPlatforms(this.availableCpuPlatforms);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDeprecated(this.deprecated);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setStatus(this.status);
            return newBuilder;
        }
    }
}

