/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Binding;
import com.google.cloud.compute.v1.Policy;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ZoneSetPolicyRequest
implements ApiMessage {
    private final List<Binding> bindings;
    private final String etag;
    private final Policy policy;
    private static final ZoneSetPolicyRequest DEFAULT_INSTANCE = new ZoneSetPolicyRequest();

    private ZoneSetPolicyRequest() {
        this.bindings = null;
        this.etag = null;
        this.policy = null;
    }

    private ZoneSetPolicyRequest(List<Binding> bindings, String etag, Policy policy) {
        this.bindings = bindings;
        this.etag = etag;
        this.policy = policy;
    }

    public Object getFieldValue(String fieldName) {
        if ("bindings".equals(fieldName)) {
            return this.bindings;
        }
        if ("etag".equals(fieldName)) {
            return this.etag;
        }
        if ("policy".equals(fieldName)) {
            return this.policy;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Binding> getBindingsList() {
        return this.bindings;
    }

    public String getEtag() {
        return this.etag;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ZoneSetPolicyRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ZoneSetPolicyRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ZoneSetPolicyRequest{bindings=" + this.bindings + ", etag=" + this.etag + ", policy=" + this.policy + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ZoneSetPolicyRequest) {
            ZoneSetPolicyRequest that = (ZoneSetPolicyRequest)o;
            return Objects.equals(this.bindings, that.getBindingsList()) && Objects.equals(this.etag, that.getEtag()) && Objects.equals(this.policy, that.getPolicy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.bindings, this.etag, this.policy);
    }

    public static class Builder {
        private List<Binding> bindings;
        private String etag;
        private Policy policy;

        Builder() {
        }

        public Builder mergeFrom(ZoneSetPolicyRequest other) {
            if (other == ZoneSetPolicyRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getBindingsList() != null) {
                this.bindings = other.bindings;
            }
            if (other.getEtag() != null) {
                this.etag = other.etag;
            }
            if (other.getPolicy() != null) {
                this.policy = other.policy;
            }
            return this;
        }

        Builder(ZoneSetPolicyRequest source) {
            this.bindings = source.bindings;
            this.etag = source.etag;
            this.policy = source.policy;
        }

        public List<Binding> getBindingsList() {
            return this.bindings;
        }

        public Builder addAllBindings(List<Binding> bindings) {
            if (this.bindings == null) {
                this.bindings = new LinkedList<Binding>();
            }
            this.bindings.addAll(bindings);
            return this;
        }

        public Builder addBindings(Binding bindings) {
            if (this.bindings == null) {
                this.bindings = new LinkedList<Binding>();
            }
            this.bindings.add(bindings);
            return this;
        }

        public String getEtag() {
            return this.etag;
        }

        public Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        public Policy getPolicy() {
            return this.policy;
        }

        public Builder setPolicy(Policy policy) {
            this.policy = policy;
            return this;
        }

        public ZoneSetPolicyRequest build() {
            return new ZoneSetPolicyRequest(this.bindings, this.etag, this.policy);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllBindings(this.bindings);
            newBuilder.setEtag(this.etag);
            newBuilder.setPolicy(this.policy);
            return newBuilder;
        }
    }
}

